/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import matteroverdrive.guide.GuideElementAbstract;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MatterOverdriveGuide;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.w3c.dom.Element;

public abstract class GuideElementTextAbstract
extends GuideElementAbstract {
    private static String shortcodePattern = "\\[(.*?)\\]";
    private static String shortcodePatternSplitter = "((?<=" + shortcodePattern + ")|(?=" + shortcodePattern + "))";

    @Override
    public void loadElement(MOGuideEntry entry, Element element, Map<String, String> styleSheetMap, int width, int height) {
        this.getFontRenderer().func_78264_a(true);
        Map<String, String> styleMap = this.buildStyleMap(styleSheetMap, element);
        this.loadStyles(entry, element, styleMap, width, height);
        this.width = this.calculateWidth(styleMap, width);
        this.loadContent(entry, element, width, height);
        this.calculateDimentions(entry, element, styleMap, width, height);
        this.getFontRenderer().func_78264_a(false);
    }

    /*
     * WARNING - void declaration
     */
    protected List<TextLine> handleTextFormatting(MOGuideEntry entry, String text, int width) {
        ArrayList<Object> shortCodeSplits = new ArrayList<Object>();
        Matcher matcher = Pattern.compile(shortcodePattern).matcher(text);
        int lastEnd = 0;
        while (matcher.find()) {
            shortCodeSplits.add(text.substring(lastEnd, matcher.start()));
            String shortcode = matcher.group();
            shortCodeSplits.add(this.handleShortCode(this.decodeShortcode(shortcode)));
            lastEnd = matcher.end();
        }
        shortCodeSplits.add(text.substring(lastEnd, text.length()));
        ArrayList<TextChunk> textChunks = new ArrayList<TextChunk>();
        for (Object e : shortCodeSplits) {
            if (e instanceof String) {
                for (String s : ((String)e).split(" ")) {
                    if (s.isEmpty()) continue;
                    textChunks.add(new TextChunk(this.handleVariables(s.trim(), entry), this.getFontRenderer()));
                }
                continue;
            }
            if (!(e instanceof TextChunk)) continue;
            textChunks.add((TextChunk)e);
        }
        ArrayList<TextLine> lines = new ArrayList<TextLine>();
        TextLine textLine = new TextLine();
        lines.add(textLine);
        for (int i = 0; i < textChunks.size(); ++i) {
            void var9_11;
            int w = this.calculateWidth(null, (TextChunk)textChunks.get(i), null);
            if (i > 0 && i < textChunks.size() - 1) {
                w = this.calculateWidth((TextChunk)textChunks.get(i - 1), (TextChunk)textChunks.get(i), (TextChunk)textChunks.get(i + 1));
            }
            if (var9_11.getWidth() + w > width) {
                TextLine textLine2 = new TextLine();
                lines.add(textLine2);
            }
            var9_11.addChunk((TextChunk)textChunks.get(i));
        }
        return lines;
    }

    protected TextChunk handleShortCode(Map<String, String> shortcodeMap) {
        MOGuideEntry entry;
        if (shortcodeMap.get("type").equalsIgnoreCase("block") || shortcodeMap.get("type").equalsIgnoreCase("item")) {
            ItemStack stack = this.shortCodeToStack(shortcodeMap);
            if (stack != null) {
                return new ItemstackTextLinkChunk(EnumChatFormatting.GREEN + stack.func_82833_r() + EnumChatFormatting.RESET, this.getFontRenderer(), stack);
            }
        } else if (shortcodeMap.get("type").equalsIgnoreCase("guide") && (entry = MatterOverdriveGuide.findGuide(shortcodeMap.get("name"))) != null) {
            return new GuideTextLinkChunk(EnumChatFormatting.YELLOW + entry.getDisplayName() + EnumChatFormatting.RESET, this.getFontRenderer(), entry);
        }
        return null;
    }

    protected String handleVariables(String text, MOGuideEntry entry) {
        return text.replace("$itemName", this.formatVariableReplace("$itemName", entry.getStackIcons().length > 0 && entry.getStackIcons()[0] != null ? entry.getStackIcons()[0].func_82833_r() : entry.getDisplayName()));
    }

    protected String formatVariableReplace(String variable, String replace) {
        return replace;
    }

    protected int calculateWidth(TextChunk before, TextChunk main, TextChunk after) {
        if (after != null && after.text.matches("[.,!\"')}]")) {
            return main.getWidth();
        }
        if (main.text.matches("[({]")) {
            return main.getWidth();
        }
        return main.getWidth() + this.getFontRenderer().func_78263_a(' ');
    }

    public class ItemstackTextLinkChunk
    extends TextChunk {
        ItemStack stack;

        public ItemstackTextLinkChunk(String text, FontRenderer fontRenderer, ItemStack stack) {
            super(text, fontRenderer);
            this.stack = stack;
        }
    }

    public class GuideTextLinkChunk
    extends TextChunk {
        MOGuideEntry entry;

        public GuideTextLinkChunk(String text, FontRenderer fontRenderer, MOGuideEntry entry) {
            super(text, fontRenderer);
            this.entry = entry;
        }
    }

    public class TextChunk {
        String text;
        int width;

        public TextChunk(String text, FontRenderer fontRenderer) {
            this.text = text;
            this.width = fontRenderer.func_78256_a(text);
        }

        public int getWidth() {
            return this.width;
        }
    }

    protected class TextLine {
        List<TextChunk> chunks = new ArrayList<TextChunk>();

        public void addChunk(TextChunk chunk) {
            this.chunks.add(chunk);
        }

        public int getWidth() {
            int width = 0;
            for (TextChunk chunk : this.chunks) {
                width += chunk.getWidth() + GuideElementTextAbstract.this.getFontRenderer().func_78263_a(' ');
            }
            return width;
        }
    }
}

