/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.guide;

import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.guide.GuideElementAbstract;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.init.MatterOverdriveRecipes;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;

public class GuideElementRecipe
extends GuideElementAbstract {
    private static final ResourceLocation background = new ResourceLocation("mo:textures/gui/elements/guide_recipe.png");
    IRecipe recipe;
    Object[] recipeItems;
    ItemStack output;

    @Override
    public void drawElement(int width, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        if (this.textAlign == 1) {
            GL11.glTranslated((double)(this.marginLeft + this.width / 2 - 55), (double)this.marginTop, (double)0.0);
        } else {
            GL11.glTranslated((double)this.marginLeft, (double)this.marginTop, (double)0.0);
        }
        this.bindTexture(background);
        RenderUtils.applyColor(Reference.COLOR_MATTER);
        RenderUtils.drawPlane(8.0, 8.0, 0.0, 96.0, 96.0);
        if (this.recipeItems != null && this.recipe != null) {
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int index = x + y * 3;
                    if (index >= this.recipeItems.length) continue;
                    if (this.recipeItems[index] instanceof ItemStack) {
                        ItemStack stack = (ItemStack)this.recipeItems[index];
                        this.renderStack(stack, x, y);
                        continue;
                    }
                    if (!(this.recipeItems[index] instanceof List)) continue;
                    List stacks = (List)this.recipeItems[index];
                    int stackIndex = (int)(Minecraft.func_71410_x().field_71441_e.func_72820_D() / 100L % (long)stacks.size());
                    if (stackIndex >= stacks.size() || !(stacks.get(stackIndex) instanceof ItemStack)) continue;
                    this.renderStack((ItemStack)stacks.get(stackIndex), x, y);
                }
            }
        }
        GL11.glPopMatrix();
    }

    private void renderStack(ItemStack stack, int x, int y) {
        if (stack != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(10 + x * 33), (double)(9 + y * 33), (double)0.0);
            GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
            RenderUtils.renderStack(0, 0, stack);
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void loadContent(MOGuideEntry entry, Element element, int width, int height) {
        this.output = element.hasAttribute("item") ? this.shortCodeToStack(this.decodeShortcode(element.getAttribute("item"))) : entry.getStackIcons()[0];
        if (this.output != null) {
            for (IRecipe recipe : MatterOverdriveRecipes.recipes) {
                if (!ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)this.output)) continue;
                this.recipe = recipe;
                break;
            }
            if (this.recipe == null) {
                for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                    if (!ItemStack.func_77989_b((ItemStack)recipe.func_77571_b(), (ItemStack)this.output)) continue;
                    this.recipe = recipe;
                    break;
                }
            }
        } else {
            MOLog.warn("There is no output Itemstack to recipe Guide Element", new Object[0]);
        }
        if (this.recipe != null) {
            if (this.recipe instanceof ShapedRecipes) {
                this.recipeItems = ((ShapedRecipes)this.recipe).field_77574_d;
            } else if (this.recipe instanceof ShapelessRecipes) {
                this.recipeItems = new ItemStack[((ShapelessRecipes)this.recipe).field_77579_b.size()];
                this.recipeItems = ((ShapelessRecipes)this.recipe).field_77579_b.toArray(this.recipeItems);
            } else if (this.recipe instanceof ShapedOreRecipe) {
                this.recipeItems = ((ShapedOreRecipe)this.recipe).getInput();
            }
        } else {
            MOLog.warn("Could not find recipe for %s in Guide Recipe Element", this.output);
        }
        this.height = 100;
        this.width = 100;
    }
}

