/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import matteroverdrive.Reference;
import matteroverdrive.container.ContainerStarMap;
import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.starmap.ElementSlotBuilding;
import matteroverdrive.gui.element.starmap.ElementSlotShip;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.tile.TileEntityMachineStarMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class PagePlanetMenu
extends ElementBaseGroup {
    TileEntityMachineStarMap starMap;
    ElementInventorySlot[] factorySlots = new ElementInventorySlot[2];
    ElementInventorySlot[] shipSlots = new ElementInventorySlot[2];

    public PagePlanetMenu(GuiBase gui, int posX, int posY, int width, int height, ContainerStarMap starMapContainer, TileEntityMachineStarMap starMap) {
        super(gui, posX, posY, width, height);
        double angle;
        int i;
        this.starMap = starMap;
        for (i = 0; i < this.factorySlots.length; ++i) {
            angle = -1.7453292519943295 + 0.20943951023931953 * (double)i;
            this.factorySlots[i] = new ElementSlotBuilding(gui, (MOSlot)starMapContainer.func_75139_a(i), width / 2 - 10 + (int)(Math.sin(angle) * 140.0), height / 2 - 48 + (int)(Math.cos(angle) * 140.0), 22, 22, "holo", ClientProxy.holoIcons.getIcon("factory"), starMap);
            this.factorySlots[i].setColor(new GuiColor(Reference.COLOR_HOLO.getIntR() / 2, Reference.COLOR_HOLO.getIntG() / 2, Reference.COLOR_HOLO.getIntB() / 2));
        }
        for (i = 0; i < this.shipSlots.length; ++i) {
            angle = -1.7453292519943295 + 0.20943951023931953 * (double)(i + this.factorySlots.length);
            MOSlot slot = (MOSlot)starMapContainer.func_75139_a(i + this.factorySlots.length);
            this.shipSlots[i] = new ElementSlotShip(gui, slot, width / 2 - 10 + (int)(Math.sin(angle) * 140.0), height / 2 - 48 + (int)(Math.cos(angle) * 140.0), 22, 22, "holo", ClientProxy.holoIcons.getIcon("icon_shuttle"), starMap);
            this.shipSlots[i].setColor(new GuiColor(Reference.COLOR_HOLO.getIntR() / 2, Reference.COLOR_HOLO.getIntG() / 2, Reference.COLOR_HOLO.getIntB() / 2));
        }
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        boolean planetSlotVisible = this.starMap.getPlanet() != null && this.starMap.getPlanet().isOwner((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        for (ElementInventorySlot slot : this.factorySlots) {
            slot.setVisible(planetSlotVisible);
        }
        for (ElementInventorySlot slot : this.shipSlots) {
            slot.setVisible(planetSlotVisible);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        if (this.starMap.getPlanet() != null) {
            GL11.glPushMatrix();
            int width = this.getFontRenderer().func_78256_a(this.starMap.getPlanet().getName());
            GL11.glTranslated((double)(this.sizeY / 2 + width / 2), (double)0.0, (double)0.0);
            GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            if (GalaxyClient.getInstance().canSeePlanetInfo(this.starMap.getPlanet(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                this.getFontRenderer().func_78276_b(this.starMap.getPlanet().getName(), 12 - width / 2, 0, Planet.getGuiColor(this.starMap.getPlanet()).getColor());
            } else {
                Minecraft.func_71410_x().field_71464_q.func_78276_b(this.starMap.getPlanet().getName(), 12 - width / 2, 0, Planet.getGuiColor(this.starMap.getPlanet()).getColor());
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void init() {
        int i;
        super.init();
        for (i = 0; i < this.factorySlots.length; ++i) {
            this.addElement(this.factorySlots[i]);
        }
        for (i = 0; i < this.shipSlots.length; ++i) {
            this.addElement(this.shipSlots[i]);
        }
    }
}

