/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element.starmap;

import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementBase;
import java.util.Map;
import matteroverdrive.Reference;
import matteroverdrive.api.starmap.IShip;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementAbstractStarMapEntry;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ElementShipEntry
extends ElementAbstractStarMapEntry<Planet> {
    int shipId;
    ItemStack ship;

    public ElementShipEntry(GuiStarMap gui, ElementGroupList groupList, int width, int height, Planet planet, ItemStack ship, int shipId) {
        super(gui, groupList, width, height, planet);
        this.ship = ship;
        this.searchIcon = ClientProxy.holoIcons.getIcon("icon_attack");
        this.shipId = shipId;
    }

    @Override
    protected void drawElementName(Planet planet, GuiColor color, float multiply) {
        RenderUtils.renderStack(this.posX + 10, this.posY + this.sizeY / 2 - 8, this.ship);
        RenderUtils.drawString(Minecraft.func_71410_x().field_71466_p, this.ship.func_82833_r(), this.posX + 31, this.posY + 12, color, multiply);
    }

    @Override
    protected Map<HoloIcon, Integer> getIcons(Planet spaceBody) {
        return null;
    }

    @Override
    protected boolean canTravelTo(Planet ship, EntityPlayer player) {
        return false;
    }

    @Override
    protected boolean canView(Planet planet, EntityPlayer player) {
        Planet to;
        if (this.ship.func_77973_b() instanceof IShip && ((IShip)this.ship.func_77973_b()).isOwner(this.ship, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) && (to = GalaxyClient.getInstance().getTheGalaxy().getPlanet(((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getDestination())) != null && to != planet) {
            return to.canAddShip(this.ship, player);
        }
        return false;
    }

    @Override
    public float getMultiply(Planet ship) {
        if (this.groupList.isSelected((ElementBase)this)) {
            return 1.0f;
        }
        return 0.1f;
    }

    @Override
    protected GuiColor getSpaceBodyColor(Planet planet) {
        if (this.canView(planet, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return Reference.COLOR_HOLO;
        }
        return Reference.COLOR_HOLO_RED;
    }

    @Override
    boolean isSelected(Planet planet) {
        return this.groupList.isSelected((ElementBase)this);
    }

    @Override
    protected void onViewPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).Attack(((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getGalaxyPosition(), ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getDestination(), this.shipId);
    }

    @Override
    protected void onTravelPress() {
    }

    @Override
    protected void onSelectPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).SyncCommandsToServer();
    }
}

