/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element.starmap;

import cofh.lib.gui.GuiColor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.Reference;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.gui.GuiStarMap;
import matteroverdrive.gui.element.ElementGroupList;
import matteroverdrive.gui.element.starmap.ElementAbstractStarMapEntry;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class ElementQuadrantEntry
extends ElementAbstractStarMapEntry<Quadrant> {
    public ElementQuadrantEntry(GuiStarMap gui, ElementGroupList groupList, int width, int height, Quadrant spaceBody) {
        super(gui, groupList, width, height, spaceBody);
    }

    @Override
    protected void drawElementName(Quadrant quadrant, GuiColor color, float multiply) {
        RenderUtils.drawString(((Quadrant)this.spaceBody).getName(), this.posX + 16, this.posY + 10, color, multiply);
    }

    @Override
    protected Map<HoloIcon, Integer> getIcons(Quadrant spaceBody) {
        HashMap<HoloIcon, Integer> icons = new HashMap<HoloIcon, Integer>();
        HoloIcon homeIcon = ClientProxy.holoIcons.getIcon("home_icon");
        for (Star star : spaceBody.getStars()) {
            if (star.isClaimed((EntityPlayer)Minecraft.func_71410_x().field_71439_g) < 2) continue;
            icons.put(homeIcon, -1);
        }
        return icons;
    }

    public void addTooltip(List<String> list) {
    }

    @Override
    protected boolean canTravelTo(Quadrant quadrant, EntityPlayer player) {
        return ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getGalaxyPosition().equals(quadrant);
    }

    @Override
    protected boolean canView(Quadrant spaceBody, EntityPlayer player) {
        return true;
    }

    @Override
    public float getMultiply(Quadrant quadrant) {
        GuiStarMap guiStarMap = (GuiStarMap)this.gui;
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getDestination().equals(quadrant)) {
            return 1.0f;
        }
        if (((TileEntityMachineStarMap)guiStarMap.getMachine()).getGalaxyPosition().equals(quadrant)) {
            return 0.5f;
        }
        return 0.1f;
    }

    @Override
    protected GuiColor getSpaceBodyColor(Quadrant planet) {
        return Reference.COLOR_HOLO;
    }

    @Override
    boolean isSelected(Quadrant quadrant) {
        return ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).getDestination().equals(quadrant);
    }

    @Override
    protected void onViewPress() {
        ((GuiStarMap)this.gui).setPage(1);
    }

    @Override
    protected void onTravelPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).setGalaxticPosition(new GalacticPosition((Quadrant)this.spaceBody));
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).SyncCommandsToServer();
    }

    @Override
    protected void onSelectPress() {
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).setDestination(new GalacticPosition((Quadrant)this.spaceBody));
        ((TileEntityMachineStarMap)((GuiStarMap)this.gui).getMachine()).SyncCommandsToServer();
    }
}

