/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.GuiColor;
import cofh.lib.gui.element.ElementTextFieldFiltered;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.events.ITextHandler;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.ResourceLocation;

public class MOElementTextField
extends ElementTextFieldFiltered {
    protected int textOffsetX;
    protected int textOffsetY;
    private ScaleTexture background = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/search_field.png"), 166, 14).setOffsets(18, 12, 9, 3);
    ITextHandler textHandler;
    private HoloIcon holoIcon;
    private GuiColor color;

    public MOElementTextField(MOGuiBase gui, ITextHandler textHandler, int posX, int posY, int width, int height) {
        super((GuiBase)gui, posX, posY, width, height);
        this.textHandler = textHandler;
    }

    public MOElementTextField(MOGuiBase gui, int posX, int posY, int width, int height) {
        this(gui, gui, posX, posY, width, height);
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        if (this.background != null) {
            this.background.Render(this.posX - this.textOffsetX, this.posY - this.textOffsetY, this.sizeX + this.textOffsetX, this.sizeY + this.textOffsetY);
        }
    }

    public void setBackground(ScaleTexture texture) {
        this.background = texture;
    }

    public void setTextOffset(int x, int y) {
        this.textOffsetX = x;
        this.textOffsetY = y;
    }

    public void setHoloIcon(HoloIcon holoIcon) {
        this.holoIcon = holoIcon;
    }

    public void setColor(GuiColor color) {
        this.color = color;
    }

    protected void onCharacterEntered(boolean success) {
        if (this.isFocused()) {
            this.textHandler.textChanged(this.getName(), this.getText(), success);
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        if (this.holoIcon != null) {
            if (this.color != null) {
                RenderUtils.applyColor(this.color);
            }
            float heightScale = (float)Math.min(this.holoIcon.getOriginalHeight(), this.sizeY) / (float)this.holoIcon.getOriginalHeight();
            ClientProxy.holoIcons.renderIcon(this.holoIcon, this.posX - this.holoIcon.getOriginalWidth() - 2, this.posY, (int)((float)this.holoIcon.getOriginalWidth() * heightScale), (int)((float)this.holoIcon.getOriginalHeight() * heightScale));
        }
    }
}

