/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.render.RenderHelper;
import matteroverdrive.data.ScaleTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class ElementProgress
extends ElementBase {
    public static final ScaleTexture FILL_TEXTURE = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/progress_slider_fill.png"), 9, 9).setOffsets(3, 6, 4, 4);
    float value;
    float maxValue;
    boolean showText = true;
    int bgU;
    int bgV;
    int fillU;
    int fillV;
    int fillSizeX;
    int fillSizeY;
    int fillX;
    int fillY;
    int textX;
    int textY;
    String text;
    int textColor;

    public ElementProgress(GuiBase gui, int fillX, int fillY, int posX, int posY, int bgU, int bgV, int fillU, int fillV, int fillSizeX, int fillSizeY, int sizeX, int sizeY) {
        super(gui, posX, posY, sizeX, sizeY);
        this.fillU = fillU;
        this.fillV = fillV;
        this.bgU = bgU;
        this.bgV = bgV;
        this.fillSizeX = fillSizeX;
        this.fillSizeY = fillSizeY;
        this.fillX = fillX;
        this.fillY = fillY;
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.bindTexture((ResourceLocation)this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, this.bgU, this.bgV, this.sizeX, this.sizeY);
        FILL_TEXTURE.Render(this.fillX, this.fillY, this.Scale(this.fillSizeX), this.fillSizeY);
        if (this.isShowText()) {
            this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, this.text, this.posX + this.textX, this.posY + this.textY, this.textColor);
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean value) {
        this.showText = value;
    }

    private int Scale(int value) {
        return (int)((float)value * (this.value / this.maxValue));
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public void SetTextPostition(int x, int y) {
        this.textX = x;
        this.textY = y;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }
}

