/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.element.ElementBase;
import cofh.lib.util.position.BlockPosition;
import java.util.HashSet;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementGrid;
import matteroverdrive.gui.element.ElementMonitorItemPattern;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ElementPatternsGrid
extends ElementGrid {
    String filter = "";

    public ElementPatternsGrid(MOGuiBase guiBase, int x, int y, int width, int height) {
        super(guiBase, x, y, width, height, width);
        this.setMargins(0, 0, 4, 0);
    }

    public void updateStackList(HashSet<BlockPosition> positions) {
        this.elements.clear();
        for (BlockPosition position : positions) {
            NBTTagList list;
            TileEntity entity = position.getTileEntity((World)Minecraft.func_71410_x().field_71441_e);
            if (!(entity instanceof IMatterDatabase) || (list = ((IMatterDatabase)entity).getItemsAsNBT()) == null) continue;
            for (int p = 0; p < list.func_74745_c(); ++p) {
                ItemStack stack = MatterDatabaseHelper.GetItemStackFromNBT(list.func_150305_b(p));
                if (MatterHelper.getMatterAmountFromItem(stack) <= 0) continue;
                this.addElement(new ElementMonitorItemPattern(this.gui, list.func_150305_b(p), (MOGuiBase)this.gui));
            }
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public boolean shouldBeDisplayed(ElementBase element) {
        if (element.getName() != null) {
            return element.getName().toLowerCase().contains(this.filter.toLowerCase());
        }
        return false;
    }
}

