/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.MathHelper;
import java.util.List;
import matteroverdrive.api.matter.IMatterStorage;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.MatterHelper;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class ElementMatterStored
extends MOElementBase {
    public static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("mo:textures/gui/elements/Matter.png");
    public static final int DEFAULT_SCALE = 42;
    private int drain = 0;
    protected IMatterStorage storage;
    protected boolean alwaysShowMinimum = false;

    public ElementMatterStored(GuiBase gui, int posX, int posY, IMatterStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
        this.texture = DEFAULT_TEXTURE;
        this.sizeX = 16;
        this.sizeY = 42;
        this.texW = 32;
        this.texH = 64;
    }

    public ElementMatterStored setAlwaysShow(boolean show) {
        this.alwaysShowMinimum = show;
        return this;
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        int amount = this.getScaled();
        RenderHelper.bindTexture((ResourceLocation)this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        this.drawTexturedModalRect(this.posX, this.posY + 42 - amount, 16, 42 - amount, this.sizeX, amount);
    }

    public void drawForeground(int mouseX, int mouseY) {
    }

    public void addTooltip(List<String> list) {
        if (this.storage.getCapacity() < 0) {
            list.add("Infinite  kM");
        } else {
            list.add(this.storage.getMatterStored() + " / " + this.storage.getCapacity() + " kM");
        }
        if (this.drain > 0) {
            list.add(EnumChatFormatting.GREEN + "+" + MatterHelper.formatMatter(this.drain));
        } else if (this.drain < 0) {
            list.add(EnumChatFormatting.RED + MatterHelper.formatMatter(this.drain));
        }
    }

    protected int getScaled() {
        if (this.storage.getCapacity() <= 0) {
            return this.sizeY;
        }
        long fraction = (long)this.storage.getMatterStored() * (long)this.sizeY / (long)this.storage.getCapacity();
        return this.alwaysShowMinimum && this.storage.getMatterStored() > 0 ? Math.max(1, MathHelper.round((double)fraction)) : MathHelper.round((double)fraction);
    }

    public void setDrain(int amount) {
        this.drain = amount;
    }
}

