/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import java.util.List;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class ElementItemPattern
extends ElementSlot {
    ScaleTexture texture;
    NBTTagCompound tagCompound;
    ItemStack itemStack;
    int amount = 0;

    public ElementItemPattern(GuiBase gui, NBTTagCompound tagCompound, String bgType, int width, int height) {
        super(gui, 0, 0, width, height, bgType);
        this.texture = new ScaleTexture(ElementItemPattern.getTexture(bgType), width, height).setOffsets(2, 2, 2, 2);
        this.tagCompound = tagCompound;
        this.itemStack = MatterDatabaseHelper.GetItemStackFromNBT(tagCompound);
        this.name = "";
        if (tagCompound != null && this.itemStack != null) {
            this.name = this.itemStack.func_82833_r();
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.tagCompound != null) {
            RenderUtils.renderStack(this.posX + 3, this.posY + 3, this.itemStack);
            if (this.amount > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
                this.gui.func_73732_a(this.getFontRenderer(), Integer.toString(this.amount), this.posX + 17, this.posY + 12, 0xFFFFFF);
                GL11.glPopMatrix();
            }
            RenderHelper.func_74520_c();
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.texture.Render(this.posX, this.posY, this.sizeX, this.sizeY);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.tagCompound != null && this.itemStack != null) {
            list.addAll(this.itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false));
            String name = list.get(0);
            int progress = MatterDatabaseHelper.GetProgressFromNBT(this.tagCompound);
            name = MatterDatabaseHelper.getPatternInfoColor(progress) + name + " [" + progress + "%]";
            list.set(0, name);
        }
    }

    public NBTTagCompound getTagCompound() {
        return this.tagCompound;
    }

    public void setTagCompound(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
        this.itemStack = MatterDatabaseHelper.GetItemStackFromNBT(tagCompound);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public ScaleTexture getTexture() {
        return this.texture;
    }
}

