/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.element.ElementBase;
import cofh.lib.util.helpers.MathHelper;
import matteroverdrive.Reference;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.MOElementButtonScaled;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class ElementIntegerField
extends ElementBaseGroup
implements IButtonHandler {
    IButtonHandler buttonHandler;
    MOElementButtonScaled incBtn;
    MOElementButtonScaled decBtn;
    ScaleTexture numberBG;
    int number;
    int min;
    int max;

    public ElementIntegerField(MOGuiBase gui, IButtonHandler buttonHandler, int posX, int posY, int width, int height, int min, int max) {
        super(gui, posX, posY, width, height);
        this.buttonHandler = buttonHandler;
        this.numberBG = new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/field_over.png"), 30, 18).setOffsets(5, 5, 5, 5);
        this.incBtn = new MOElementButtonScaled(gui, this, 0, 0, "Inc", 16, height);
        this.incBtn.setNormalTexture(new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/button_normal_left.png"), 10, 18).setOffsets(5, 2, 5, 5));
        this.incBtn.setOverTexture(null);
        this.incBtn.setText("+");
        this.decBtn = new MOElementButtonScaled(gui, this, width - 16, 0, "Dec", 16, height);
        this.decBtn.setNormalTexture(new ScaleTexture(new ResourceLocation("mo:textures/gui/elements/button_normal_right.png"), 10, 18).setOffsets(2, 5, 5, 5));
        this.decBtn.setText("-");
        this.min = min;
        this.max = max;
    }

    public ElementIntegerField(MOGuiBase gui, IButtonHandler buttonHandler, int posX, int posY, int width, int height) {
        this(gui, buttonHandler, posX, posY, width, height, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void init() {
        super.init();
        this.addElement((ElementBase)this.incBtn);
        this.addElement((ElementBase)this.decBtn);
    }

    public ElementIntegerField(MOGuiBase gui, IButtonHandler buttonHandler, int posX, int posY) {
        this(gui, buttonHandler, posX, posY, 120, 18, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int getNumber() {
        return MathHelper.clampI((int)this.number, (int)this.min, (int)this.max);
    }

    public void setNumber(int number) {
        this.number = MathHelper.clampI((int)number, (int)this.min, (int)this.max);
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String buttonName, int mouseButton) {
        if (buttonName == "Inc") {
            int value = 1;
            if (Keyboard.isKeyDown((int)42)) {
                value = 64;
            } else if (Keyboard.isKeyDown((int)29)) {
                value = 16;
            }
            this.setNumber(this.getNumber() + value);
            this.buttonHandler.handleElementButtonClick(this, this.getName(), value);
        } else if (buttonName == "Dec") {
            int value = -1;
            if (Keyboard.isKeyDown((int)42)) {
                value = -64;
            } else if (Keyboard.isKeyDown((int)29)) {
                value = -16;
            }
            this.setNumber(this.getNumber() + value);
            this.buttonHandler.handleElementButtonClick(this, this.getName(), value);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        super.drawBackground(mouseX, mouseY, gameTicks);
        this.numberBG.Render(this.posX + 16, this.posY, this.sizeX - 32, this.sizeY);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        String number = Integer.toString(this.number);
        int numberWidth = this.getFontRenderer().func_78256_a(number);
        this.getFontRenderer().func_78276_b(number, this.posX - numberWidth / 2 + this.sizeX / 2, this.posY - this.getFontRenderer().field_78288_b / 2 + this.sizeY / 2, Reference.COLOR_GUI_DARKER.getColor());
    }

    public void setBounds(int min, int max) {
        this.min = min;
        this.max = max;
    }
}

