/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import java.util.ArrayList;
import java.util.List;
import matteroverdrive.container.IButtonHandler;
import matteroverdrive.gui.GuiElementList;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import org.lwjgl.opengl.GL11;

public class ElementBaseGroup
extends MOElementBase
implements IButtonHandler,
GuiElementList {
    protected ArrayList<ElementBase> elements = new ArrayList();

    public ElementBaseGroup(GuiBase gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementBaseGroup(GuiBase gui, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
    }

    @Override
    public void init() {
        this.elements.clear();
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        mX -= this.getGlobalX();
        mY -= this.getGlobalY();
        int i = this.getElements().size();
        while (i-- > 0) {
            ElementBase element = this.getElements().get(i);
            if (mY < 0 || mY > this.sizeY || mX < 0 || mX > this.sizeX || !element.intersectsWith(mX, mY) || !element.isVisible()) continue;
            return element;
        }
        return null;
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.handleTooltips(mouseX, mouseY);
        mouseX -= this.getGlobalX();
        mouseY -= this.getGlobalY();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.getElements().size();
        while (i-- > 0) {
            ElementBase c = this.getElements().get(i);
            if (!c.isVisible()) continue;
            c.drawBackground(mouseX, mouseY, gameTicks);
        }
        GL11.glPopMatrix();
    }

    protected void handleTooltips(int mouseX, int mouseY) {
        ElementBase element;
        if (this.gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null && (element = this.getElementAtPosition(mouseX, mouseY)) != null) {
            element.addTooltip(((MOGuiBase)this.gui).getTooltips());
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
        mouseX -= this.getGlobalX();
        mouseY -= this.getGlobalY();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.getElements().size();
        while (i-- > 0) {
            ElementBase c = this.getElements().get(i);
            if (!c.isVisible()) continue;
            c.drawForeground(mouseX, mouseY);
        }
        GL11.glPopMatrix();
    }

    public void update(int mouseX, int mouseY) {
        mouseX -= this.getGlobalX();
        mouseY -= this.getGlobalY();
        int i = this.elements.size();
        while (i-- > 0) {
            this.getElements().get(i).update(mouseX, mouseY);
        }
        this.update();
    }

    @Override
    public void updateInfo() {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = this.elements.get(i);
            if (!(element instanceof MOElementBase)) continue;
            ((MOElementBase)element).updateInfo();
        }
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        mouseX -= this.getGlobalX();
        mouseY -= this.getGlobalY();
        int i = this.getElements().size();
        while (i-- > 0) {
            ElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY) || !c.onMousePressed(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    public void onMouseReleased(int mouseX, int mouseY) {
        mouseX -= this.getGlobalX();
        mouseY -= this.getGlobalY();
        int i = this.getElements().size();
        while (i-- > 0) {
            ElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled()) continue;
            c.onMouseReleased(mouseX, mouseY);
        }
    }

    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        int i = this.getElements().size();
        while (i-- > 0) {
            ElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY) || !c.onMouseWheel(mouseX, mouseY, movement)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(char characterTyped, int keyPressed) {
        int i = this.getElements().size();
        while (i-- > 0) {
            ElementBase c = this.getElements().get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.onKeyTyped(characterTyped, keyPressed)) continue;
            return true;
        }
        return false;
    }

    public MOElementBase setGroupVisible(boolean visible) {
        super.setVisible(visible);
        return this;
    }

    @Override
    public void handleElementButtonClick(ElementBase element, String buttonName, int mouseButton) {
    }

    public List<ElementBase> getElements() {
        return this.elements;
    }

    public ElementBase addElementAt(int i, ElementBase element) {
        if (element instanceof MOElementBase) {
            ((MOElementBase)element).parent = this;
        }
        this.elements.add(i, element);
        return element;
    }

    @Override
    public ElementBase addElement(ElementBase element) {
        if (element == null) {
            return null;
        }
        if (element instanceof MOElementBase) {
            ((MOElementBase)element).parent = this;
        }
        this.elements.add(element);
        return element;
    }
}

