/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.android;

import cofh.lib.gui.GuiColor;
import java.text.DecimalFormat;
import matteroverdrive.Reference;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.gui.android.AndroidHudElement;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class AndroidHudStats
extends AndroidHudElement {
    public static final ResourceLocation top_element_bg = new ResourceLocation("mo:textures/gui/elements/android_bg_element.png");

    public AndroidHudStats(AndroidHudPosition position, String name) {
        super(position, name, 174, 32);
    }

    @Override
    public boolean isVisible(AndroidPlayer android) {
        return true;
    }

    @Override
    public void drawElement(AndroidPlayer androidPlayer, int mouseX, int mouseY, ScaledResolution resolution, float ticks) {
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(this.baseColor);
        this.mc.field_71446_o.func_110577_a(top_element_bg);
        RenderUtils.drawPlane(0.0, 10.0, 0.0, 174.0, 11.0);
        double energy_perc = (double)androidPlayer.getEnergyStored() / (double)androidPlayer.getMaxEnergyStored();
        double health_perc = (double)androidPlayer.getPlayer().func_110143_aJ() / androidPlayer.getPlayer().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        int x = 12;
        GuiColor healthColor = RenderUtils.lerp(Reference.COLOR_HOLO_RED, this.baseColor, (float)Math.min(health_perc, 1.0));
        RenderUtils.applyColorWithAlpha(healthColor);
        ClientProxy.holoIcons.renderIcon("health", x, 22);
        x += 18;
        String info = DecimalFormat.getPercentInstance().format(health_perc);
        this.mc.field_71466_p.func_78276_b(info, 32, 28, healthColor.getColor());
        GuiColor energyColor = RenderUtils.lerp(Reference.COLOR_HOLO_RED, this.baseColor, (float)energy_perc);
        RenderUtils.applyColorWithAlpha(energyColor);
        ClientProxy.holoIcons.renderIcon("battery", x += this.mc.field_71466_p.func_78256_a(info) + 5, 20, 22, 22);
        info = DecimalFormat.getPercentInstance().format(energy_perc);
        this.mc.field_71466_p.func_78276_b(info, x += 22, 28, energyColor.getColor());
        RenderUtils.applyColorWithAlpha(this.baseColor);
        ClientProxy.holoIcons.renderIcon("person", x += this.mc.field_71466_p.func_78256_a(info) + 5, 22, 18, 18);
        info = DecimalFormat.getPercentInstance().format(androidPlayer.getSpeedMultiply());
        this.mc.field_71466_p.func_78276_b(info, x += 18, 28, this.baseColor.getColor());
        GL11.glEnable((int)3008);
    }
}

