/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.android;

import cofh.lib.gui.GuiColor;
import cofh.lib.render.RenderHelper;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.gui.android.AndroidHudElement;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.gui.android.AndroidHudStats;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class AndroidHudBionicStats
extends AndroidHudElement {
    public static final int STATS_PER_ROW = 6;
    private int lastHeightCount = 0;

    public AndroidHudBionicStats(AndroidHudPosition position, String name) {
        super(position, name, 174, 0);
    }

    @Override
    public boolean isVisible(AndroidPlayer android) {
        return true;
    }

    @Override
    public void drawElement(AndroidPlayer android, int mouseX, int mouseY, ScaledResolution resolution, float ticks) {
        int count = 0;
        for (int i = 0; i < android.func_70302_i_(); ++i) {
            if (android.func_70301_a(i) == null) continue;
            this.drawAndroidPart(android.func_70301_a(i), this.baseColor, this.getX(count), this.getY(count));
            ++count;
        }
        for (Object object : android.getUnlocked().func_150296_c()) {
            int level;
            IBionicStat stat = MatterOverdrive.statRegistry.getStat(object.toString());
            if (stat == null || !stat.showOnHud(android, level = android.getUnlockedLevel(stat))) continue;
            if (!stat.isEnabled(android, level)) {
                this.drawBioticStat(stat, android, level, Reference.COLOR_HOLO_RED, this.getX(count), this.getY(count));
            } else {
                this.drawBioticStat(stat, android, level, this.baseColor, this.getX(count), this.getY(count));
            }
            ++count;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (this.getPosition().y == 1.0f) {
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(0.0, Math.ceil((double)count / 6.0) * 24.0 + 4.0, 0.0, 174.0, 11.0);
        } else {
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(0.0, 10.0, 0.0, 174.0, 11.0);
        }
        this.lastHeightCount = count;
    }

    private void drawAndroidPart(ItemStack stack, GuiColor color, int x, int y) {
        this.drawNormalBG(color, x, y);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glBlendFunc((int)770, (int)1);
        RenderHelper.bindItemTexture((ItemStack)stack);
        RenderUtils.renderStack(x + 3, y + 3, stack);
        GL11.glDisable((int)3042);
    }

    private void drawBioticStat(IBionicStat stat, AndroidPlayer androidPlayer, int level, GuiColor color, int x, int y) {
        if (stat.isActive(androidPlayer, level)) {
            this.drawActiveBG(color, x, y);
        } else {
            this.drawNormalBG(color, x, y);
        }
        GL11.glEnable((int)3042);
        ClientProxy.holoIcons.bindSheet();
        RenderHelper.renderIcon((double)(x + 2), (double)(y + 2), (double)0.0, (IIcon)stat.getIcon(level), (int)18, (int)18);
        GL11.glDisable((int)3042);
    }

    private void drawNormalBG(GuiColor color, int x, int y) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(color);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg", x, y, 22, 22);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    private void drawActiveBG(GuiColor color, int x, int y) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(color);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg_active", x, y, 22, 22);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    private int getX(int count) {
        if (this.getPosition().x == 1.0f) {
            return (int)(this.getPosition().x * 150.0f) - (12 + 24 * (count % 6));
        }
        if (this.getPosition().x == 0.0f) {
            return 12 + 24 * (count % 6);
        }
        return 144 - (12 + 24 * (count % 6));
    }

    private int getY(int count) {
        if (this.getPosition().y == 1.0f) {
            return -24 * (count / 6 - 2) - 20;
        }
        return 23 + 24 * (count / 6);
    }

    @Override
    public int getHeight(ScaledResolution resolution) {
        return 23 + 24 * (int)Math.ceil((double)this.lastHeightCount / 6.0) + 24;
    }
}

