/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.weapon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.concurrent.TimeUnit;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.IGravityEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PhaserFire
extends Entity
implements IProjectile,
IGravityEntity {
    private int field_145791_d = -1;
    private int field_145792_e = -1;
    private int field_145789_f = -1;
    private int ticksInAir;
    private float damage;
    public Entity shootingEntity;
    private Block block;
    private int life;
    private int color;
    private float fireDamageMultiply;

    public PhaserFire(World p_i1753_1_) {
        super(p_i1753_1_);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public PhaserFire(World world, EntityLivingBase entityLivingBase, Vec3 position, Vec3 dir, float damage, float speed, float accuracy, int color, boolean isAiming, int seed) {
        this(world, entityLivingBase, position, dir, damage, speed, accuracy, 60, color, isAiming, seed);
    }

    public PhaserFire(World world, EntityLivingBase entityLivingBase, Vec3 position, Vec3 dir, float damage, float speed, float accuracy, int life, int color, boolean isAiming, int seed) {
        super(world);
        this.field_70146_Z.setSeed(seed);
        this.field_70155_l = 10.0;
        this.shootingEntity = entityLivingBase;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, entityLivingBase.field_70177_z, entityLivingBase.field_70125_A);
        this.field_70159_w = dir.field_72450_a;
        this.field_70181_x = dir.field_72448_b;
        this.field_70179_y = dir.field_72449_c;
        this.field_70129_M = 0.0f;
        this.life = life;
        this.damage = damage;
        this.color = color;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed * 1.5f, accuracy);
    }

    public void func_70186_c(double x, double y, double z, float speed, float accuracy) {
        float dirLength = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)dirLength;
        y /= (double)dirLength;
        z /= (double)dirLength;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)accuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)accuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)accuracy;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void func_70071_h_() {
        Block block;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((block = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f)).func_149688_o() != Material.field_151579_a) {
            block.func_149719_a((IBlockAccess)this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            AxisAlignedBB axisalignedbb = block.func_149668_a(this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.func_70106_y();
            }
        }
        if (this.ticksInAir > this.life) {
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        Vec3 vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
        vec31 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        vec3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (movingobjectposition != null) {
            vec3 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            float f1;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == this.shootingEntity || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f1 = 0.3f), (double)f1, (double)f1)).func_72327_a(vec31, vec3)) == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null && entity != this.shootingEntity) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                movingobjectposition = null;
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72308_g != null) {
                float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                int k = MathHelper.func_76143_f((double)((double)f2 * (double)this.damage));
                DamageSource damagesource = null;
                damagesource = this.shootingEntity == null ? DamageSource.func_76356_a((Entity)this, (Entity)this) : DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity);
                if (movingobjectposition.field_72308_g.func_70097_a(damagesource, (float)k)) {
                    if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                        EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                        if (this.shootingEntity != null && this.shootingEntity instanceof EntityLivingBase) {
                            EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                            EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                        }
                        if (this.shootingEntity != null && movingobjectposition.field_72308_g != this.shootingEntity && movingobjectposition.field_72308_g instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                        }
                    }
                    if (this.fireDamageMultiply > 0.0f) {
                        movingobjectposition.field_72308_g.func_70015_d((int)(80.0f * this.fireDamageMultiply));
                    }
                    if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                        this.func_70106_y();
                    }
                } else {
                    for (int s = 0; s < 10; ++s) {
                        this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
                    }
                    this.func_70106_y();
                }
            } else {
                this.field_145791_d = movingobjectposition.field_72311_b;
                this.field_145792_e = movingobjectposition.field_72312_c;
                this.field_145789_f = movingobjectposition.field_72309_d;
                this.block = this.field_70170_p.func_147439_a(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                if (this.block.func_149688_o() != Material.field_151579_a) {
                    this.block.func_149670_a(this.field_70170_p, this.field_145791_d, this.field_145792_e, this.field_145789_f, (Entity)this);
                }
                for (int s = 0; s < 10; ++s) {
                    this.field_70170_p.func_72869_a("smoke", movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c, 0.0, 0.0, 0.0);
                }
                this.func_70106_y();
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public void simulate(long delay) {
        long averageTickTime;
        if (!this.field_70170_p.field_72995_K && (averageTickTime = TimeUnit.NANOSECONDS.toMillis(MatterOverdrive.tickHandler.getLastTickLength())) > 0L) {
            int simulationCount = (int)(delay / averageTickTime);
            for (int i = 0; i < simulationCount; ++i) {
                this.func_70071_h_();
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.field_145791_d);
        tagCompound.func_74777_a("yTile", (short)this.field_145792_e);
        tagCompound.func_74777_a("zTile", (short)this.field_145789_f);
        tagCompound.func_74776_a("damage", this.damage);
        tagCompound.func_74768_a("ticksInAir", this.ticksInAir);
        tagCompound.func_74768_a("life", this.life);
        tagCompound.func_74768_a("color", this.color);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.field_145791_d = tagCompound.func_74765_d("xTile");
        this.field_145792_e = tagCompound.func_74765_d("yTile");
        this.field_145789_f = tagCompound.func_74765_d("zTile");
        if (tagCompound.func_150297_b("damage", 99)) {
            this.damage = tagCompound.func_74760_g("damage");
        }
        if (tagCompound.func_150297_b("ticksInAir", 99)) {
            this.ticksInAir = tagCompound.func_74762_e("ticksInAir");
        }
        if (tagCompound.func_150297_b("life", 99)) {
            this.life = tagCompound.func_74762_e("life");
        }
        if (tagCompound.func_150297_b("color", 99)) {
            this.color = tagCompound.func_74762_e("color");
        }
    }

    public void func_70100_b_(EntityPlayer p_70100_1_) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setDamage(float p_70239_1_) {
        this.damage = p_70239_1_;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean func_70075_an() {
        return false;
    }

    public int getColor() {
        return this.color;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public boolean isAffectedByAnomaly() {
        return false;
    }

    public void setFireDamageMultiply(float fiery) {
        this.fireDamageMultiply = fiery;
    }
}

