/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.HashSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.EntityRougeAndroidMob;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveEntities;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Property;

public class EntityRogueAndroid
implements IConfigSubscriber {
    private static HashSet<String> biomesBlacklist = new HashSet();
    private static HashSet<String> biomesWhitelist = new HashSet();
    public static HashSet<Integer> dimentionBlacklist = new HashSet();
    public static HashSet<Integer> dimentionWhitelist = new HashSet();
    private static BiomeGenBase.SpawnListEntry spawnListEntry;

    public static void registerEntity() {
        EntityRogueAndroid.createEntity(EntityRougeAndroidMob.class, "rogue_android", 1048575, 0);
    }

    public static void createEntity(Class<? extends EntityLiving> entityClass, String name, int solidColor, int spotColor) {
        int randomID = MatterOverdriveEntities.registerEntityGlobalIDSafe(entityClass, name);
        EntityRegistry.registerGlobalEntityID(entityClass, (String)name, (int)randomID);
        EntityRegistry.registerModEntity(entityClass, (String)name, (int)randomID, (Object)MatterOverdrive.instance, (int)64, (int)1, (boolean)true);
        spawnListEntry = new BiomeGenBase.SpawnListEntry(entityClass, 5, 1, 2);
        EntityRogueAndroid.addInBiome(BiomeGenBase.func_150565_n());
        EntityRogueAndroid.createEgg(randomID, solidColor, spotColor);
    }

    private static void addInBiome(BiomeGenBase[] biomes) {
        EntityRogueAndroid.loadBiomeBlacklist(MatterOverdrive.configHandler);
        EntityRogueAndroid.loadBiomesWhitelist(MatterOverdrive.configHandler);
        for (int i = 0; i < biomes.length; ++i) {
            if (biomes[i] == null) continue;
            List spawnList = biomes[i].func_76747_a(EnumCreatureType.monster);
            if (!EntityRogueAndroid.isBiomeValid(biomes[i]) || spawnList.contains(spawnList)) continue;
            spawnList.add(spawnListEntry);
        }
    }

    private static boolean isBiomeValid(BiomeGenBase biome) {
        if (biome != null) {
            if (biomesWhitelist.size() > 0) {
                return biomesWhitelist.contains(biome);
            }
            return !biomesBlacklist.contains(biome.field_76791_y.toLowerCase());
        }
        return false;
    }

    public static void createEgg(int id, int solidColor, int spotColor) {
        EntityList.field_75627_a.put(id, new EntityList.EntityEggInfo(id, solidColor, spotColor));
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        if (spawnListEntry != null) {
            EntityRogueAndroid.spawnListEntry.field_76292_a = config.config.getInt("spawn_chance", "entities.rogue_android", 5, 0, 100, "The spawn change of the Rogue Android");
        }
        EntityRogueAndroid.loadDimensionBlacklist(config);
        EntityRogueAndroid.loadDimesionWhitelist(config);
        EntityRogueAndroid.loadBiomeBlacklist(config);
        EntityRogueAndroid.loadBiomesWhitelist(config);
    }

    private static void loadBiomeBlacklist(ConfigurationHandler config) {
        biomesBlacklist.clear();
        String[] blacklist = config.config.getStringList("biome.blacklist", "entities.rogue_android", new String[]{"Hell", "Sky"}, "Rouge Android biome blacklist");
        for (int i = 0; i < blacklist.length; ++i) {
            biomesBlacklist.add(blacklist[i].toLowerCase());
        }
    }

    private static void loadBiomesWhitelist(ConfigurationHandler configurationHandler) {
        biomesWhitelist.clear();
        String[] whitelist = configurationHandler.config.getStringList("biome.whitelist", "entities.rogue_android", new String[0], "Rouge Android biome whitelist");
        for (int i = 0; i < whitelist.length; ++i) {
            biomesBlacklist.add(whitelist[i].toLowerCase());
        }
    }

    private static void loadDimensionBlacklist(ConfigurationHandler configurationHandler) {
        dimentionBlacklist.clear();
        Property blacklistProp = configurationHandler.config.get("entities.rogue_android", "dimension.blacklist", new int[]{1});
        blacklistProp.comment = "Rouge Android Dimension ID blacklist";
        int[] blacklist = blacklistProp.getIntList();
        for (int i = 0; i < blacklist.length; ++i) {
            dimentionBlacklist.add(blacklist[i]);
        }
    }

    private static void loadDimesionWhitelist(ConfigurationHandler configurationHandler) {
        dimentionWhitelist.clear();
        Property whitelistProp = configurationHandler.config.get("entities.rogue_android", "dimension.whitelist", new int[0]);
        whitelistProp.comment = "Rouge Android Dimension ID whitelist";
        int[] whitelist = whitelistProp.getIntList();
        for (int i = 0; i < whitelist.length; ++i) {
            dimentionWhitelist.add(whitelist[i]);
        }
    }
}

