/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyStorage;
import cofh.lib.audio.SoundBase;
import cofh.lib.util.helpers.MathHelper;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBionicStat;
import matteroverdrive.api.inventory.IBionicPart;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.MinimapEntityInfo;
import matteroverdrive.data.inventory.BionicSlot;
import matteroverdrive.data.inventory.EnergySlot;
import matteroverdrive.entity.AndroidAttributes;
import matteroverdrive.gui.GuiAndroidHud;
import matteroverdrive.network.packet.client.PacketSendMinimapInfo;
import matteroverdrive.network.packet.client.PacketSyncAndroid;
import matteroverdrive.network.packet.server.PacketAndroidChangeAbility;
import matteroverdrive.network.packet.server.PacketSendAndroidAnction;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.Level;

public class AndroidPlayer
implements IExtendedEntityProperties,
IEnergyStorage,
IInventory {
    public static final int BUILTIN_ENERGY_TRANSFER = 1024;
    public static final int TRANSFORM_TIME = 680;
    public static final String EFFECT_KEY_TURNING = "Turning";
    public static final String EXT_PROP_NAME = "AndroidPlayer";
    public static final int ENERGY_WATCHER = 29;
    public static final int ENERGY_FOOD_MULTIPLY = 256;
    public static final int ENERGY_PER_JUMP = 512;
    public static final float FALL_NEGATE = 0.5f;
    public final float DEFAULT_WLAK_SPEED = 0.1f;
    public final float DEFAULT_FLY_SPEED = 0.05f;
    public final float DEFAULT_JUMP_MOVEMENT_FACTOR = 0.02f;
    public static final float SPEED_MULTIPLY = 1.25f;
    public static final float POERLESS_SPEED_MULTIPLY = 0.25f;
    public static final int ENERGY_PER_EXOST = 16;
    public static final int MINIMAP_SEND_TIMEOUT = 40;
    public static final AttributeModifier outOfPowerSpeedModifyer = new AttributeModifier(UUID.fromString("ec778ddc-9711-498b-b9aa-8e5adc436e00"), "Android Out of Power", -0.5, 2).func_111168_a(false);
    private static List<IBionicStat> wheelStats = new ArrayList<IBionicStat>();
    private static Map<Integer, MinimapEntityInfo> entityInfoMap = new HashMap<Integer, MinimapEntityInfo>();
    private ItemStack[] previousBionicPatts = new ItemStack[5];
    public final int ENERGY_SLOT;
    private final EntityPlayer player;
    private Inventory inventory;
    private IBionicStat activeStat;
    NBTTagCompound unlocked;
    NBTTagCompound effects;
    int maxEnergy;
    boolean isAndroid;

    public AndroidPlayer(EntityPlayer player) {
        this.player = player;
        this.maxEnergy = 512000;
        this.inventory = new Inventory("Android");
        this.inventory.AddSlot(new BionicSlot(false, 0));
        this.inventory.AddSlot(new BionicSlot(false, 1));
        this.inventory.AddSlot(new BionicSlot(false, 2));
        this.inventory.AddSlot(new BionicSlot(false, 3));
        this.inventory.AddSlot(new BionicSlot(false, 4));
        this.ENERGY_SLOT = this.inventory.AddSlot(new EnergySlot(false));
        this.unlocked = new NBTTagCompound();
        this.effects = new NBTTagCompound();
        int energyWatchID = MatterOverdrive.configHandler.getInt("android energy watch id", "abilities", 29);
        try {
            player.func_70096_w().func_75682_a(energyWatchID, (Object)this.maxEnergy);
        }
        catch (IllegalArgumentException e) {
            MOLog.log(Level.ERROR, e, "Android Energy Watch ID taken. Starting id iteration.", new Object[0]);
            for (energyWatchID = 8; energyWatchID <= 31; ++energyWatchID) {
                try {
                    player.func_70096_w().func_75682_a(energyWatchID, (Object)this.maxEnergy);
                    break;
                }
                catch (IllegalArgumentException ex) {
                    MOLog.log(Level.ERROR, ex, "Android Energy Watch ID '%s' taken.", energyWatchID);
                    continue;
                }
            }
        }
        MatterOverdrive.configHandler.setInt("android energy watch id", "abilities", energyWatchID);
        this.registerAttributes(player);
    }

    public void registerAttributes(EntityPlayer player) {
        player.func_110140_aT().func_111150_b(AndroidAttributes.attributeGlitchTime);
        player.func_110140_aT().func_111150_b(AndroidAttributes.attributeBatteryUse);
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new AndroidPlayer(player));
    }

    public static AndroidPlayer get(EntityPlayer player) {
        return (AndroidPlayer)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound prop = new NBTTagCompound();
        prop.func_74768_a("Energy", this.player.func_70096_w().func_75679_c(29));
        prop.func_74768_a("MaxEnergy", this.maxEnergy);
        prop.func_74757_a("isAndroid", this.isAndroid);
        prop.func_74782_a("Stats", (NBTBase)this.unlocked);
        prop.func_74782_a("Effects", (NBTBase)this.effects);
        if (this.activeStat != null) {
            prop.func_74778_a("ActiveAbility", this.activeStat.getUnlocalizedName());
        }
        this.inventory.writeToNBT(prop);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)prop);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound prop = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.player.func_70096_w().func_75692_b(29, (Object)prop.func_74762_e("Energy"));
        this.maxEnergy = prop.func_74762_e("MaxEnergy");
        this.isAndroid = prop.func_74767_n("isAndroid");
        this.unlocked = prop.func_74775_l("Stats");
        this.effects = prop.func_74775_l("Effects");
        if (prop.func_74764_b("ActiveAbility")) {
            this.activeStat = MatterOverdrive.statRegistry.getStat(prop.func_74779_i("ActiveAbility"));
        }
        this.inventory.readFromNBT(prop);
    }

    public void init(Entity entity, World world) {
        this.manageStatAttributeModifiers();
    }

    public int extractEnergy(int amount, boolean simulate) {
        int energyExtracted;
        if (this.player.field_71075_bZ.field_75098_d) {
            return amount;
        }
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).func_77973_b() instanceof IEnergyContainerItem) {
            ItemStack battery = this.func_70301_a(this.ENERGY_SLOT);
            IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)battery.func_77973_b();
            energyExtracted = energyContainerItem.extractEnergy(battery, amount, simulate);
            if (energyExtracted > 0 && !simulate) {
                this.sync(0);
            }
        } else {
            int energy = this.player.func_70096_w().func_75679_c(29);
            energyExtracted = Math.min(Math.min(energy, amount), 1024);
            if (!simulate) {
                energy -= energyExtracted;
                energy = MathHelper.clampI((int)energy, (int)0, (int)this.getMaxEnergyStored());
                this.player.func_70096_w().func_75692_b(29, (Object)energy);
            }
        }
        return energyExtracted;
    }

    public boolean isUnlocked(IBionicStat stat, int level) {
        return this.unlocked.func_74764_b(stat.getUnlocalizedName()) && this.unlocked.func_74762_e(stat.getUnlocalizedName()) >= level;
    }

    public int getUnlockedLevel(IBionicStat stat) {
        if (this.unlocked.func_74764_b(stat.getUnlocalizedName())) {
            return this.unlocked.func_74762_e(stat.getUnlocalizedName());
        }
        return 0;
    }

    public boolean tryUnlock(IBionicStat stat, int level) {
        if (stat.canBeUnlocked(this, level)) {
            this.unlock(stat, level);
            return true;
        }
        return false;
    }

    public void unlock(IBionicStat stat, int level) {
        this.clearAllStatAttributeModifiers();
        this.unlocked.func_74768_a(stat.getUnlocalizedName(), level);
        stat.onUnlock(this, level);
        this.sync(2);
        this.manageStatAttributeModifiers();
    }

    public int getEnergyStored() {
        if (this.player.field_71075_bZ.field_75098_d) {
            return this.getMaxEnergyStored();
        }
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)this.func_70301_a(this.ENERGY_SLOT).func_77973_b()).getEnergyStored(this.func_70301_a(this.ENERGY_SLOT));
        }
        return this.player.func_70096_w().func_75679_c(29);
    }

    public int getMaxEnergyStored() {
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)this.func_70301_a(this.ENERGY_SLOT).func_77973_b()).getMaxEnergyStored(this.func_70301_a(this.ENERGY_SLOT));
        }
        return this.maxEnergy;
    }

    public int receiveEnergy(int amount, boolean simulate) {
        int energyReceived;
        if (this.func_70301_a(this.ENERGY_SLOT) != null && this.func_70301_a(this.ENERGY_SLOT).func_77973_b() instanceof IEnergyContainerItem) {
            ItemStack battery = this.func_70301_a(this.ENERGY_SLOT);
            IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)battery.func_77973_b();
            energyReceived = energyContainerItem.receiveEnergy(battery, amount, simulate);
            this.sync(0);
        } else {
            int energy = this.player.func_70096_w().func_75679_c(29);
            energyReceived = Math.min(Math.min(this.getMaxEnergyStored() - energy, amount), 1024);
            if (!simulate) {
                energy += energyReceived;
                energy = MathHelper.clampI((int)energy, (int)0, (int)this.getMaxEnergyStored());
                this.player.func_70096_w().func_75692_b(29, (Object)energy);
            }
        }
        return energyReceived;
    }

    public void setAndroid(boolean isAndroid) {
        this.isAndroid = isAndroid;
        this.sync(-1);
        if (isAndroid) {
            this.previousBionicPatts = new ItemStack[5];
            this.manageStatAttributeModifiers();
        } else {
            this.clearAllStatAttributeModifiers();
            this.clearAllEquipmentAttributeModifiers();
        }
    }

    public boolean isAndroid() {
        return this.isAndroid;
    }

    public void sync(int part) {
        this.sync(this.player, part, false);
    }

    public void sync(int part, boolean others) {
        this.sync(this.player, part, others);
    }

    public void sync(EntityPlayer player, int syncPart, boolean toOthers) {
        if (player instanceof EntityPlayerMP) {
            if (toOthers) {
                MatterOverdrive.packetPipeline.sendToAllAround((IMessage)new PacketSyncAndroid(this, syncPart), player, 64.0);
            } else {
                MatterOverdrive.packetPipeline.sendTo(new PacketSyncAndroid(this, syncPart), (EntityPlayerMP)player);
            }
        }
    }

    public void setActionToServer(int action, boolean state) {
        this.setActionToServer(action, state, 0);
    }

    public void setActionToServer(int action, boolean state, int options) {
        MatterOverdrive.packetPipeline.sendToServer(new PacketSendAndroidAnction(action, state, options));
    }

    public void copy(AndroidPlayer player) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        player.saveNBTData(tagCompound);
        this.loadNBTData(tagCompound);
        this.manageStatAttributeModifiers();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound getUnlocked() {
        return this.unlocked;
    }

    public void setUnlocked(NBTTagCompound unlocked) {
        this.unlocked = unlocked;
    }

    public void resetUnlocked() {
        this.unlocked = new NBTTagCompound();
        this.sync(2);
        this.clearAllStatAttributeModifiers();
    }

    public void reset(IBionicStat stat) {
        if (this.getUnlocked().func_74764_b(stat.getUnlocalizedName())) {
            this.getUnlocked().func_82580_o(stat.getUnlocalizedName());
            this.sync(2);
            this.manageStatAttributeModifiers();
        }
    }

    public NBTTagCompound getEffects() {
        return this.effects;
    }

    public void setEffects(NBTTagCompound effects) {
        this.effects = effects;
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        AndroidPlayer androidPlayer = AndroidPlayer.get(event.player);
        if (androidPlayer != null) {
            if (event.side.isServer() && event.phase == TickEvent.Phase.START) {
                if (androidPlayer.isAndroid()) {
                    if (this.getEnergyStored() > 0) {
                        if (event.player.func_71024_bL().func_75121_c() && androidPlayer.getEnergyStored() > 0) {
                            int foodNeeded = 20 - event.player.func_71024_bL().func_75116_a();
                            int extractedEnergy = androidPlayer.extractEnergy(foodNeeded * 256, false);
                            event.player.func_71024_bL().func_75122_a(extractedEnergy / 256, 0.0f);
                        }
                        this.manageHasPower();
                        this.managePotionEffects();
                    } else if (this.getEnergyStored() <= 0) {
                        this.manageOutOfPower();
                    }
                    this.manageCharging();
                    this.manageEquipmentAttributeModifiers();
                    if (!event.player.field_70170_p.field_72995_K) {
                        this.manageMinimapInfo(event);
                    }
                }
                this.manageTurning();
            }
            if (event.side.isClient() && androidPlayer.isAndroid()) {
                this.manageAbilityWheel();
            }
            if (androidPlayer.isAndroid()) {
                this.manageGlitch();
                this.manageSwimming();
                this.manageAir();
                for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
                    int unlockedLevel = androidPlayer.getUnlockedLevel(stat);
                    if (unlockedLevel <= 0) continue;
                    if (stat.isEnabled(androidPlayer, unlockedLevel)) {
                        stat.changeAndroidStats(androidPlayer, unlockedLevel, true);
                        stat.onAndroidUpdate(androidPlayer, unlockedLevel);
                        continue;
                    }
                    stat.changeAndroidStats(androidPlayer, unlockedLevel, false);
                }
            }
        }
    }

    public void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        this.manageStatAttributeModifiers();
    }

    private void clearAllEquipmentAttributeModifiers() {
        for (int j = 0; j < 5; ++j) {
            Multimap multimap;
            ItemStack itemstack = this.previousBionicPatts[j];
            ItemStack itemstack1 = this.inventory.func_70301_a(j);
            if (itemstack1 == null || itemstack1 == null || !(itemstack1.func_77973_b() instanceof IBionicPart) || (multimap = ((IBionicPart)itemstack1.func_77973_b()).getModifiers(this, itemstack1)) == null) continue;
            this.player.func_110140_aT().func_111148_a(multimap);
        }
    }

    private void manageEquipmentAttributeModifiers() {
        boolean needsSync = false;
        for (int j = 0; j < 5; ++j) {
            Multimap multimap;
            ItemStack itemstack = this.previousBionicPatts[j];
            ItemStack itemstack1 = this.inventory.func_70301_a(j);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            if (itemstack != null && itemstack.func_77973_b() instanceof IBionicPart && (multimap = ((IBionicPart)itemstack.func_77973_b()).getModifiers(this, itemstack)) != null) {
                this.player.func_110140_aT().func_111148_a(multimap);
            }
            if (itemstack1 != null && itemstack1.func_77973_b() instanceof IBionicPart && (multimap = ((IBionicPart)itemstack1.func_77973_b()).getModifiers(this, itemstack1)) != null) {
                this.player.func_110140_aT().func_111147_b(multimap);
            }
            this.previousBionicPatts[j] = itemstack1 == null ? null : itemstack1.func_77946_l();
            needsSync = true;
        }
        if (needsSync) {
            this.sync(4, true);
        }
    }

    private void clearAllStatAttributeModifiers() {
        for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
            int unlockedLevel;
            Multimap multimap = stat.attributes(this, unlockedLevel = this.getUnlockedLevel(stat));
            if (multimap == null) continue;
            this.player.func_110140_aT().func_111148_a(multimap);
        }
    }

    private void manageStatAttributeModifiers() {
        for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
            int unlockedLevel;
            Multimap multimap = stat.attributes(this, unlockedLevel = this.getUnlockedLevel(stat));
            if (multimap == null) continue;
            if (this.isAndroid()) {
                if (unlockedLevel > 0) {
                    if (stat.isEnabled(this, unlockedLevel)) {
                        this.player.func_110140_aT().func_111147_b(multimap);
                        continue;
                    }
                    this.player.func_110140_aT().func_111148_a(multimap);
                    continue;
                }
                this.player.func_110140_aT().func_111148_a(multimap);
                continue;
            }
            this.player.func_110140_aT().func_111148_a(multimap);
        }
    }

    private void manageMinimapInfo(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerMP && event.player.field_70170_p.func_72820_D() % 40L == 0L) {
            ArrayList<MinimapEntityInfo> entityList = new ArrayList<MinimapEntityInfo>();
            for (Object entityObject : event.player.field_70170_p.field_72996_f) {
                if (!(entityObject instanceof EntityLivingBase) || !AndroidPlayer.isVisibleOnMinimap((EntityLivingBase)entityObject, this.player, Vec3.func_72443_a((double)((EntityLivingBase)entityObject).field_70165_t, (double)((EntityLivingBase)entityObject).field_70163_u, (double)((EntityLivingBase)entityObject).field_70161_v).func_72444_a(Vec3.func_72443_a((double)this.player.field_70165_t, (double)this.player.field_70163_u, (double)this.player.field_70161_v))) || !MinimapEntityInfo.hasInfo((EntityLivingBase)entityObject, this.player)) continue;
                entityList.add(new MinimapEntityInfo((EntityLivingBase)entityObject, event.player));
            }
            if (entityList.size() > 0) {
                MatterOverdrive.packetPipeline.sendTo(new PacketSendMinimapInfo(entityList), (EntityPlayerMP)event.player);
            }
        }
    }

    public static boolean isVisibleOnMinimap(EntityLivingBase entityLivingBase, EntityPlayer player, Vec3 relativePosition) {
        return !entityLivingBase.func_82150_aj() && Math.abs(relativePosition.field_72448_b) < 16.0 && AndroidPlayer.isInRangeToRenderDist(entityLivingBase, 256.0);
    }

    private static boolean isInRangeToRenderDist(EntityLivingBase entityLivingBase, double p_70112_1_) {
        double d1 = entityLivingBase.field_70121_D.func_72320_b();
        return p_70112_1_ < (d1 *= 64.0 * entityLivingBase.field_70155_l) * d1;
    }

    public void manageOutOfPower() {
        IAttributeInstance speed = this.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (speed.func_111127_a(outOfPowerSpeedModifyer.func_111167_a()) == null) {
            speed.func_111121_a(outOfPowerSpeedModifyer);
        }
        if (this.player.field_70170_p.field_72995_K && this.player.field_70170_p.func_72820_D() % 60L == 0L) {
            this.getEffects().func_74768_a("GlitchTime", 5);
            this.playGlitchSoundClient(this.player.field_70170_p.field_73012_v, 0.2f);
        }
    }

    public void manageHasPower() {
        IAttributeInstance speed = this.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (speed.func_111127_a(outOfPowerSpeedModifyer.func_111167_a()) != null) {
            speed.func_111124_b(outOfPowerSpeedModifyer);
        }
    }

    public void manageCharging() {
        if (this.player.func_70093_af() && this.player.func_70694_bm() != null && this.player.func_70694_bm().func_77973_b() instanceof IEnergyContainerItem) {
            int freeEnergy = this.getMaxEnergyStored() - this.getEnergyStored();
            int receivedAmount = ((IEnergyContainerItem)this.player.func_70694_bm().func_77973_b()).extractEnergy(this.player.func_70694_bm(), freeEnergy, false);
            this.receiveEnergy(receivedAmount, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageAbilityWheel() {
        GuiAndroidHud.showRadial = ClientProxy.keyHandler.getBinding(2).func_151470_d();
        if (GuiAndroidHud.showRadial) {
            double mag = Math.sqrt(GuiAndroidHud.radialDeltaX * GuiAndroidHud.radialDeltaX + GuiAndroidHud.radialDeltaY * GuiAndroidHud.radialDeltaY);
            double magAcceptance = 0.2;
            double radialAngle = -720.0;
            if (mag > magAcceptance) {
                double aSin = Math.toDegrees(Math.asin(GuiAndroidHud.radialDeltaX));
                if (GuiAndroidHud.radialDeltaY >= 0.0 && GuiAndroidHud.radialDeltaX >= 0.0) {
                    radialAngle = aSin;
                } else if (GuiAndroidHud.radialDeltaY < 0.0 && GuiAndroidHud.radialDeltaX >= 0.0) {
                    radialAngle = 90.0 + (90.0 - aSin);
                } else if (GuiAndroidHud.radialDeltaY < 0.0 && GuiAndroidHud.radialDeltaX < 0.0) {
                    radialAngle = 180.0 - aSin;
                } else if (GuiAndroidHud.radialDeltaY >= 0.0 && GuiAndroidHud.radialDeltaX < 0.0) {
                    radialAngle = 270.0 + (90.0 + aSin);
                }
            }
            if (mag > 0.9999999) {
                mag = Math.round(mag);
            }
            wheelStats.clear();
            for (IBionicStat stat : MatterOverdrive.statRegistry.getStats()) {
                if (!stat.showOnWheel(this, this.getUnlockedLevel(stat)) || !this.isUnlocked(stat, 0)) continue;
                wheelStats.add(stat);
            }
            if (mag > magAcceptance) {
                GuiAndroidHud.radialAngle = radialAngle;
            }
            if (wheelStats.size() <= 0) {
                GuiAndroidHud.showRadial = false;
                return;
            }
            int i = 0;
            for (IBionicStat stat : wheelStats) {
                float leeway = 360.0f / (float)wheelStats.size();
                if (mag > magAcceptance && (i == 0 && (radialAngle < (double)(leeway / 2.0f) && radialAngle >= 0.0 || radialAngle > (double)(360.0f - leeway / 2.0f)) || i != 0 && radialAngle < (double)(leeway * (float)i + leeway / 2.0f) && radialAngle > (double)(leeway * (float)i - leeway / 2.0f))) {
                    if (this.activeStat == stat) break;
                    this.activeStat = stat;
                    MatterOverdrive.packetPipeline.sendToServer(new PacketAndroidChangeAbility(this.activeStat.getUnlocalizedName()));
                    break;
                }
                ++i;
            }
        }
    }

    public void startConversion() {
        if (!this.isAndroid() && !this.isTurning()) {
            if (this.player.field_70170_p.field_72995_K) {
                this.playTransformMusic();
            } else {
                AndroidPlayer androidPlayer = AndroidPlayer.get(this.player);
                androidPlayer.startTurningToAndroid();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playTransformMusic() {
        SoundBase transform_music = new SoundBase("mo:transformation_music", 1.0f, 1.0f, false, 0, 0.0, 0.0, 0.0, ISound.AttenuationType.NONE);
        if (!Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)transform_music)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)transform_music);
        }
    }

    public void onEntityHurt(LivingHurtEvent event) {
        if (this.isAndroid() && !event.isCanceled()) {
            this.effects.func_74768_a("GlitchTime", this.moddify(10, AndroidAttributes.attributeGlitchTime));
            this.sync(1);
            this.player.field_70170_p.func_72956_a((Entity)this.player, "mo:gui.glitch_" + this.player.field_70170_p.field_73012_v.nextInt(11), 0.2f, 0.9f + this.player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        }
    }

    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (this.isAndroid() && !event.entity.field_70170_p.field_72995_K) {
            this.extractEnergy(512, false);
        }
    }

    private void managePotionEffects() {
        if (this.isAndroid()) {
            this.player.func_70674_bp();
        }
    }

    public double getSpeedMultiply() {
        return this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / this.player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
    }

    private void manageGlitch() {
        if (this.effects.func_74764_b("GlitchTime")) {
            if (this.effects.func_74762_e("GlitchTime") > 0) {
                this.effects.func_74768_a("GlitchTime", this.effects.func_74762_e("GlitchTime") - 1);
            } else {
                this.effects.func_82580_o("GlitchTime");
            }
        }
    }

    public int moddify(int amount, IAttribute attribute) {
        IAttributeInstance glitchAttribute = this.player.func_110148_a(attribute);
        if (glitchAttribute != null) {
            amount = (int)((double)amount * glitchAttribute.func_111126_e());
        }
        return amount;
    }

    public float moddify(float amount, IAttribute attribute) {
        IAttributeInstance glitchAttribute = this.player.func_110148_a(attribute);
        if (glitchAttribute != null) {
            amount = (int)((double)amount * glitchAttribute.func_111126_e());
        }
        return amount;
    }

    private void manageSwimming() {
        if (this.player.func_70090_H()) {
            this.player.field_70181_x -= 0.007;
        }
    }

    private void manageAir() {
        if (this.player.func_70086_ai() < 0) {
            this.player.func_70050_g(0);
        }
    }

    private void manageTurning() {
        if (this.effects.func_74764_b(EFFECT_KEY_TURNING)) {
            DamageSource fake = new DamageSource("android_transformation");
            fake.func_151518_m();
            fake.func_76348_h();
            if (this.effects.func_74762_e(EFFECT_KEY_TURNING) > 0) {
                this.effects.func_74768_a(EFFECT_KEY_TURNING, this.effects.func_74762_e(EFFECT_KEY_TURNING) - 1);
                this.getPlayer().func_70690_d(new PotionEffect(9, 680));
                this.getPlayer().func_70690_d(new PotionEffect(2, 680, 1));
                this.getPlayer().func_70690_d(new PotionEffect(17, 680));
                this.getPlayer().func_70690_d(new PotionEffect(18, 680));
                if (this.effects.func_74762_e(EFFECT_KEY_TURNING) % 40 == 0) {
                    this.player.func_70097_a(fake, 0.1f);
                    if (this.player.field_70170_p.field_72995_K) {
                        this.playGlitchSound(this, this.player.field_70170_p.field_73012_v, 0.2f);
                    }
                }
            } else {
                this.effects.func_82580_o(EFFECT_KEY_TURNING);
                this.setAndroid(true);
                this.playGlitchSound(this, this.player.field_70170_p.field_73012_v, 0.8f);
                if (!this.player.field_71075_bZ.field_75098_d) {
                    this.player.func_70097_a(fake, 2.1474836E9f);
                    this.player.func_70106_y();
                }
            }
            this.sync(1);
        }
    }

    public void playGlitchSound(AndroidPlayer player, Random random, float amount) {
        player.getPlayer().field_70170_p.func_72908_a(player.getPlayer().field_70165_t, player.getPlayer().field_70163_u, player.getPlayer().field_70163_u, "mo:gui.glitch_" + random.nextInt(11), amount, 0.9f + random.nextFloat() * 0.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public void playGlitchSoundClient(Random random, float amount) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SoundBase("mo:gui.glitch_" + random.nextInt(11), amount, 0.9f + random.nextFloat() * 0.2f));
    }

    public boolean isTurning() {
        return this.effects.func_74764_b(EFFECT_KEY_TURNING) && this.effects.func_74762_e(EFFECT_KEY_TURNING) > 0;
    }

    public static void onEntityFall(LivingFallEvent event) {
        AndroidPlayer props = AndroidPlayer.get((EntityPlayer)event.entity);
        if (props != null && props.isAndroid()) {
            event.distance *= 0.5f;
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    private void startTurningToAndroid() {
        this.effects.func_74768_a(EFFECT_KEY_TURNING, 680);
        this.sync(1);
    }

    public long getEffectLong(String effect) {
        return this.getEffects().func_74763_f(effect);
    }

    public IBionicStat getActiveStat() {
        return this.activeStat;
    }

    public void setActiveStat(IBionicStat stat) {
        this.activeStat = stat;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.player.getDisplayName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setMinimapEntityInfo(List<MinimapEntityInfo> entityInfo) {
        entityInfoMap.clear();
        for (MinimapEntityInfo info : entityInfo) {
            entityInfoMap.put(info.getEntityID(), info);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static MinimapEntityInfo getMinimapEntityInfo(EntityLivingBase entityLivingBase) {
        return entityInfoMap.get(entityLivingBase.func_145782_y());
    }
}

