/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.dialog.IDialogMessageSeedable;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.dialog.DialogMessage;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.EntityPlayer;

public class DialogMessageRandom
extends DialogMessage
implements IDialogMessageSeedable {
    public static Random random = new Random();
    protected long seed;
    protected List<String> messages;
    protected List<String> questions;

    public DialogMessageRandom() {
        this.init();
    }

    public DialogMessageRandom(String message, String question) {
        super(message, question);
        this.init();
    }

    public DialogMessageRandom(String message) {
        super(message);
        this.init();
    }

    private void init() {
        this.questions = new ArrayList<String>();
        this.messages = new ArrayList<String>();
    }

    public DialogMessageRandom addQuestionVariation(String question) {
        this.questions.add(question);
        return this;
    }

    public DialogMessageRandom addQuestionVariation(String ... questions) {
        for (String question : questions) {
            this.questions.add(question);
        }
        return this;
    }

    public DialogMessageRandom addMessageVariation(String message) {
        this.messages.add(message);
        return this;
    }

    public DialogMessageRandom addMessageVariation(String ... messages) {
        for (String message : messages) {
            this.messages.add(message);
        }
        return this;
    }

    @Override
    public String getMessageText(IDialogNpc npc, EntityPlayer player) {
        if (this.messages.size() > 0) {
            random.setSeed(this.seed);
            return this.formatMessage(this.messages.get(random.nextInt(this.messages.size())), npc, player);
        }
        return this.message;
    }

    @Override
    public String getQuestionText(IDialogNpc npc, EntityPlayer player) {
        if (this.questions.size() > 0) {
            random.setSeed(this.seed);
            return this.formatQuestion(this.questions.get(random.nextInt(this.questions.size())), npc, player);
        }
        return this.question;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public DialogMessage loadMessageFromLocalization(String key) {
        this.addMessageVariation(MOStringHelper.translateToLocal(key).split(";"));
        return this;
    }

    @Override
    public DialogMessage loadQuestionFromLocalization(String key) {
        this.addQuestionVariation(MOStringHelper.translateToLocal(key).split(";"));
        return this;
    }
}

