/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import cofh.lib.audio.SoundBase;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import java.util.UUID;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.lwjgl.input.Keyboard;

public class BioticStatShield
extends AbstractBioticStat
implements IConfigSubscriber {
    public static int ENERGY_PER_TICK = 64;
    public static int ENERGY_PER_DAMAGE = 256;
    public static final String TAG_SHIELD = "Shield";
    public static final String TAG_HITS = "Hits";
    @SideOnly(value=Side.CLIENT)
    private SoundBase shieldSound;
    private AttributeModifier modifyer;
    private Random random;

    public BioticStatShield(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.modifyer = new AttributeModifier(UUID.fromString("ead117ad-105a-43fe-ab22-a31aee6adc42"), "Shield Slowdown", -0.8, 2);
        this.random = new Random();
        this.setShowOnWheel(true);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (android.getPlayer().field_70170_p.field_72995_K) {
            if (android.getEffects().func_74767_n(TAG_SHIELD)) {
                if (!ClientProxy.keyHandler.getBinding(1).func_151470_d()) {
                    android.setActionToServer(0, false);
                    android.getEffects().func_74757_a(TAG_SHIELD, false);
                    android.getEffects().func_82580_o(TAG_HITS);
                }
            } else if (ClientProxy.keyHandler.getBinding(1).func_151470_d() && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
                this.setShield(android, true);
                android.setActionToServer(0, true);
            }
        } else {
            if (android.getEffects().func_74767_n(TAG_SHIELD)) {
                android.extractEnergy(ENERGY_PER_TICK, false);
            }
            if (android.getEffects().func_74764_b(TAG_HITS)) {
                NBTTagList attackList = android.getEffects().func_150295_c(TAG_HITS, 10);
                if (attackList.func_74745_c() > 0) {
                    if (attackList.func_150305_b(0).func_74762_e("time") > 0) {
                        attackList.func_150305_b(0).func_74768_a("time", attackList.func_150305_b(0).func_74762_e("time") - 1);
                    } else {
                        attackList.func_74744_a(0);
                    }
                } else {
                    android.getEffects().func_82580_o(TAG_HITS);
                }
                android.sync(1, true);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, KeyBinding keyBinding) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    public void setShield(AndroidPlayer androidPlayer, boolean on) {
        androidPlayer.getEffects().func_74757_a(TAG_SHIELD, on);
        androidPlayer.sync(1, true);
    }

    @Override
    public String getDetails(int level) {
        String key = "Unknown";
        try {
            key = Keyboard.getKeyName((int)ClientProxy.keyHandler.getBinding(1).func_151463_i());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format(super.getDetails(level), key);
    }

    public boolean getShieldState(AndroidPlayer androidPlayer) {
        return androidPlayer.getEffects().func_74767_n(TAG_SHIELD);
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof LivingAttackEvent) {
            DamageSource source = ((LivingAttackEvent)event).source;
            if (this.getShieldState(androidPlayer)) {
                int energyReqired = MathHelper.func_76123_f((float)(((LivingAttackEvent)event).ammount * (float)ENERGY_PER_DAMAGE));
                if (this.isDamageValid(source) && event.isCancelable()) {
                    int energyExtracted;
                    if (source.func_76364_f() != null) {
                        NBTTagCompound attack = new NBTTagCompound();
                        NBTTagList attackList = androidPlayer.getEffects().func_150295_c(TAG_HITS, 10);
                        attack.func_74780_a("x", source.func_76364_f().field_70165_t - event.entityLiving.field_70165_t);
                        attack.func_74780_a("y", source.func_76364_f().field_70163_u - (event.entityLiving.field_70163_u + 1.5));
                        attack.func_74780_a("z", source.func_76364_f().field_70161_v - event.entityLiving.field_70161_v);
                        attack.func_74768_a("time", 10);
                        attackList.func_74742_a((NBTBase)attack);
                        androidPlayer.getEffects().func_74782_a(TAG_HITS, (NBTBase)attackList);
                        androidPlayer.sync(1, true);
                        androidPlayer.getPlayer().field_70170_p.func_72956_a((Entity)androidPlayer.getPlayer(), "mo:shield_hit_" + this.random.nextInt(2), 0.5f, 0.9f + this.random.nextFloat() * 0.2f);
                    }
                    if ((energyExtracted = androidPlayer.extractEnergy(energyReqired, true)) == energyReqired) {
                        event.setCanceled(true);
                        androidPlayer.extractEnergy(energyReqired, false);
                    }
                }
            }
        } else if (event instanceof LivingHurtEvent) {
            DamageSource source = ((LivingHurtEvent)event).source;
            if (this.getShieldState(androidPlayer)) {
                int energyReqired = MathHelper.func_76123_f((float)(((LivingHurtEvent)event).ammount * (float)ENERGY_PER_DAMAGE));
                if (this.isDamageValid(source)) {
                    int energyExtracted = androidPlayer.extractEnergy(energyReqired, true);
                    ((LivingHurtEvent)event).ammount *= (float)energyExtracted / (float)energyReqired;
                }
            }
        } else if (event instanceof LivingEvent.LivingJumpEvent && this.getShieldState(androidPlayer)) {
            event.entityLiving.field_70181_x -= 0.5;
        }
    }

    public boolean isDamageValid(DamageSource damageSource) {
        return damageSource.func_94541_c() || damageSource.func_76352_a();
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (!androidPlayer.getEffects().func_74767_n(TAG_SHIELD)) {
            if (androidPlayer.getPlayer().field_70170_p.field_72995_K) {
                this.stopShieldSound();
            }
        } else {
            if (androidPlayer.getPlayer().field_70170_p.field_72995_K) {
                this.playShieldSound();
            }
            if (!(!androidPlayer.getPlayer().field_70170_p.field_72995_K || ClientProxy.keyHandler.getBinding(1).func_151470_d() && this.isEnabled(androidPlayer, level))) {
                androidPlayer.setActionToServer(0, false);
            }
        }
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected void playShieldSound() {
        if (this.shieldSound == null && !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.shieldSound)) {
            this.shieldSound = new SoundBase("mo:shield_loop", 1.0f, 1.0f, true, 0);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.shieldSound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void stopShieldSound() {
        if (this.shieldSound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.shieldSound)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.shieldSound);
            this.shieldSound = null;
        }
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        return super.isEnabled(androidPlayer, level) && androidPlayer.extractEnergy(ENERGY_PER_TICK, true) >= ENERGY_PER_TICK && androidPlayer.getActiveStat() != null && androidPlayer.getActiveStat().equals(this);
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return this.getShieldState(androidPlayer);
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return android.getActiveStat() != null && android.getActiveStat().equals(this);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_DAMAGE = config.getInt("shield_energy_per_damage", "abilities", 256, "The energy cost of each hit to the shield");
        ENERGY_PER_TICK = config.getInt("shield_energy_per_tick", "abilities", 64, "The energy cost of the shield per tick");
    }
}

