/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.AndroidPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class BioticStatNanoArmor
extends AbstractBioticStat {
    public BioticStatNanoArmor(String name, int xp) {
        super(name, xp);
        this.setMaxLevel(4);
        this.setShowOnHud(true);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, KeyBinding keyBinding) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), EnumChatFormatting.GREEN + DecimalFormat.getPercentInstance().format(this.getDamageNegate(level)) + EnumChatFormatting.GRAY);
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof LivingHurtEvent && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, androidPlayer))) {
            ((LivingHurtEvent)event).ammount *= 1.0f - this.getDamageNegate(level);
        }
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && android.getEnergyStored() > 0;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    public float getDamageNegate(int level) {
        return (float)(1 + level) * 0.06f;
    }
}

