/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BioticStatCloak
extends AbstractBioticStat
implements IConfigSubscriber {
    public static int ENERGY_PER_TICK = 128;

    public BioticStatCloak(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.setShowOnWheel(true);
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), EnumChatFormatting.YELLOW.toString() + ENERGY_PER_TICK + " RF");
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K) {
            if (this.isActive(android, level) && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, android))) {
                if (!android.getPlayer().func_82150_aj()) {
                    android.getPlayer().field_70170_p.func_72956_a((Entity)android.getPlayer(), "mo:cloak_on", 1.0f, 1.0f);
                }
                android.getPlayer().func_82142_c(true);
                android.extractEnergy(ENERGY_PER_TICK, false);
            } else {
                if (android.getPlayer().func_82150_aj()) {
                    android.getPlayer().field_70170_p.func_72956_a((Entity)android.getPlayer(), "mo:cloak_off", 1.0f, 1.0f);
                }
                android.getPlayer().func_82142_c(false);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, KeyBinding keyBinding) {
        if (androidPlayer.getActiveStat() != null && androidPlayer.getActiveStat().equals(this)) {
            boolean cloak = !androidPlayer.getEffects().func_74767_n("Cloaked");
            androidPlayer.setActionToServer(1, cloak);
        }
    }

    public void setActive(AndroidPlayer android, int level, boolean active) {
        android.getEffects().func_74757_a("Cloaked", active);
        android.sync(1, true);
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (!this.isEnabled(androidPlayer, level) && this.isActive(androidPlayer, level)) {
            androidPlayer.setActionToServer(1, false);
        }
    }

    @Override
    public Multimap attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getEffects().func_74767_n("Cloaked") && !androidPlayer.getPlayer().func_71039_bw();
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        return super.isEnabled(androidPlayer, level) && androidPlayer.extractEnergy(ENERGY_PER_TICK, true) >= ENERGY_PER_TICK;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_TICK = config.getInt("cloak_energy_per_tick", "abilities", 128, "The energy cost of the Cloak");
    }
}

