/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import cofh.lib.util.helpers.MathHelper;
import matteroverdrive.api.matter.IMatterStorage;
import matteroverdrive.init.MatterOverdriveFluids;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class MatterStorage
implements IMatterStorage,
IFluidTank {
    protected int capacity;
    protected int maxExtract;
    protected int maxReceive;
    private FluidStack fluidStack = new FluidStack((Fluid)MatterOverdriveFluids.matterPlasma, 0);

    public MatterStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public MatterStorage(int capacity, int maxExtract) {
        this(capacity, maxExtract, maxExtract);
    }

    public MatterStorage(int capacity, int maxExtract, int maxReceive) {
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
        this.capacity = capacity;
    }

    @Override
    public int getMatterStored() {
        return this.fluidStack.amount;
    }

    @Override
    public void setMatterStored(int amount) {
        this.fluidStack.amount = amount;
    }

    @Override
    public int extractMatter(ForgeDirection direction, int amount, boolean simulate) {
        return this.extractMatter(amount, simulate);
    }

    public int extractMatter(int amount, boolean simulate) {
        int maxDrain = MathHelper.clampI((int)Math.min(amount, this.getMaxExtract()), (int)0, (int)this.getFluid().amount);
        if (!simulate) {
            this.getFluid().amount -= maxDrain;
        }
        return maxDrain;
    }

    @Override
    public int receiveMatter(ForgeDirection side, int amount, boolean simulate) {
        int maxFill = MathHelper.clampI((int)Math.min(amount, this.getMaxReceive()), (int)0, (int)(this.getCapacity() - this.getFluid().amount));
        if (!simulate) {
            this.getFluid().amount += maxFill;
        }
        return maxFill;
    }

    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public int getFluidAmount() {
        return this.getFluid().amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.getFluid() == null) {
            return Math.min(this.capacity, resource.amount);
        }
        if (!this.getFluid().isFluidEqual(resource)) {
            return 0;
        }
        return this.receiveMatter(ForgeDirection.UNKNOWN, resource.amount, !doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.getFluid() == null) {
            return null;
        }
        int drained = this.extractMatter(ForgeDirection.UNKNOWN, maxDrain, !doDrain);
        if (drained <= 0) {
            return null;
        }
        return new FluidStack((Fluid)MatterOverdriveFluids.matterPlasma, drained);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Matter", this.getMatterStored());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.setMatterStored(nbt.func_74762_e("Matter"));
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }
}

