/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.data.MatterStorage;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.tile.MOTileEntityMachineMatter;

public class MachineMatterStorage<T extends MOTileEntityMachineMatter>
extends MatterStorage {
    protected final T machine;
    protected int matter;
    protected int capacity;
    protected int maxExtract;
    protected int maxReceive;

    public MachineMatterStorage(T machine, int capacity) {
        this(machine, capacity, capacity, capacity);
    }

    public MachineMatterStorage(T machine, int capacity, int maxExtract) {
        this(machine, capacity, maxExtract, maxExtract);
    }

    public MachineMatterStorage(T machine, int capacity, int maxExtract, int maxReceive) {
        super(capacity, maxExtract, maxReceive);
        this.machine = machine;
    }

    @Override
    public int getCapacity() {
        return Math.max(0, (int)((double)super.getCapacity() * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.MatterStorage)));
    }

    @Override
    public int getMaxExtract() {
        return Math.max(0, (int)((double)super.getMaxExtract() * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.MatterTransfer)));
    }

    @Override
    public int getMaxReceive() {
        return Math.max(0, (int)((double)super.getMaxReceive() * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.MatterTransfer)));
    }
}

