/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.container;

import cofh.lib.util.helpers.InventoryHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.container.slot.SlotInventory;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.data.inventory.UpgradeSlot;
import matteroverdrive.machines.MOTileEntityMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ContainerMachine<T extends MOTileEntityMachine>
extends MOBaseContainer {
    protected T machine;
    protected int progressScaled;

    public ContainerMachine() {
    }

    public ContainerMachine(InventoryPlayer inventory, T machine) {
        super(inventory);
        this.machine = machine;
        this.init(inventory);
    }

    protected void init(InventoryPlayer inventory) {
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.machine != null) {
            short progressScaled = (short)(((MOTileEntityMachine)this.machine).getProgress() * 32767.0f);
            for (Object icrafting : this.field_75149_d) {
                if (this.progressScaled != progressScaled) {
                    ((ICrafting)icrafting).func_71112_a((Container)this, 0, (int)progressScaled);
                }
                this.progressScaled = progressScaled;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int slot, int newValue) {
        if (slot == 0) {
            this.progressScaled = newValue;
        }
    }

    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return true;
    }

    public void AddUpgradeSlots(Inventory inventory) {
        this.AddUpgradeSlots(inventory, 0, 0);
    }

    public void AddUpgradeSlots(Inventory inventory, int x, int y) {
        int upgradeSlotIndex = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!(inventory.getSlot(i) instanceof UpgradeSlot)) continue;
            this.func_75146_a(new SlotInventory((IInventory)inventory, inventory.getSlot(i), x + upgradeSlotIndex % 5 * 24, y + upgradeSlotIndex / 5 * 24));
            ++upgradeSlotIndex;
        }
    }

    public void addAllSlotsFromInventory(Inventory inventory) {
        for (Slot slot : inventory.getSlots()) {
            this.func_75146_a(new SlotInventory((IInventory)inventory, inventory.getSlot(slot.getId()), 0, 0));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack itemstack = null;
        net.minecraft.inventory.Slot slot = (net.minecraft.inventory.Slot)this.field_75151_b.get(slotID);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotID < ((MOTileEntityMachine)this.machine).func_70302_i_()) {
                this.putInPlayerInventory(itemstack1);
            } else if (slotID >= ((MOTileEntityMachine)this.machine).func_70302_i_()) {
                this.tryAndPutInMachineSlots(itemstack1, (IInventory)this.machine);
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    protected boolean putInPlayerInventory(ItemStack itemStack) {
        return InventoryHelper.mergeItemStack((List)this.field_75151_b, (ItemStack)itemStack, (int)((MOTileEntityMachine)this.machine).func_70302_i_(), (int)(this.field_75151_b.size() - ((MOTileEntityMachine)this.machine).func_70302_i_()), (boolean)true, (boolean)true);
    }

    protected boolean tryAndPutInMachineSlots(ItemStack itemStack, IInventory inventory) {
        return InventoryHelper.mergeItemStack((List)this.field_75151_b, (ItemStack)itemStack, (int)0, (int)inventory.func_70302_i_(), (boolean)false, (boolean)true);
    }

    public T getMachine() {
        return this.machine;
    }

    public float getProgress() {
        return (float)this.progressScaled / 32767.0f;
    }
}

