/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import cofh.lib.gui.GuiColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import matteroverdrive.Reference;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererStars;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.GalaxyClient;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class StarMapRendererQuadrant
extends StarMapRendererStars {
    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float viewerDistance) {
        if (spaceBody instanceof Quadrant) {
            GL11.glLineWidth((float)1.0f);
            Quadrant quadrant = (Quadrant)spaceBody;
            double distanceMultiply = 5.0;
            double halfQuadrantSize = (double)quadrant.getSize() * 1.5;
            double x = (double)(-quadrant.getX() - quadrant.getSize() / 2.0f) * distanceMultiply;
            double y = (double)(-quadrant.getY()) * distanceMultiply;
            double z = (double)(-quadrant.getZ() - quadrant.getSize() / 2.0f) * distanceMultiply;
            GL11.glTranslated((double)x, (double)y, (double)z);
            this.renderStars(quadrant, starMap, distanceMultiply, distanceMultiply);
        }
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        GL11.glEnable((int)3008);
        Star star = galaxy.getStar(starMap.getDestination());
        Star origin = galaxy.getStar(starMap.getGalaxyPosition());
        if (star != null) {
            int planetCount = star.getPlanets().size();
            GuiColor color = Reference.COLOR_HOLO;
            if (planetCount <= 0) {
                color = Reference.COLOR_HOLO_RED;
            }
            RenderUtils.applyColorWithMultipy(color, opacity);
            ClientProxy.holoIcons.renderIcon("page_icon_planet", 0, -32);
            RenderUtils.drawString(String.format("x%s", planetCount), 28, -21, color, opacity);
            DecimalFormat format = new DecimalFormat("#");
            if (GalaxyClient.getInstance().canSeeStarInfo(star, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                RenderUtils.drawString(star.getName(), 0, -52, Reference.COLOR_HOLO, opacity);
            } else {
                RenderUtils.drawString(Minecraft.func_71410_x().field_71464_q, star.getName(), 0, -52, Reference.COLOR_HOLO, opacity);
            }
            ClientProxy.holoIcons.renderIcon("icon_size", 48, -28);
            RenderUtils.drawString(DecimalFormat.getPercentInstance().format(star.getSize()), 68, -23, Reference.COLOR_HOLO, opacity);
            if (origin != null) {
                RenderUtils.drawString(String.format("Distance: %s LY", format.format(origin.getPosition().func_72438_d(star.getPosition()) * 8000.0)), 0, -42, Reference.COLOR_HOLO, opacity);
            }
        }
        GL11.glDisable((int)3008);
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return true;
    }

    @Override
    public double getHologramHeight(SpaceBody spaceBody) {
        return 0.3;
    }
}

