/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity.starmap;

import cofh.lib.gui.GuiColor;
import matteroverdrive.Reference;
import matteroverdrive.api.starmap.IShip;
import matteroverdrive.client.render.tileentity.starmap.StarMapRendererPlanet;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.TravelEvent;
import matteroverdrive.tile.TileEntityMachineStarMap;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class StarMapRenderPlanetStats
extends StarMapRendererPlanet {
    @Override
    public void renderBody(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float viewerDistance) {
        if (spaceBody instanceof Planet) {
            GL11.glLineWidth((float)1.0f);
            Planet to = (Planet)spaceBody;
            Planet from = galaxy.getPlanet(starMap.getGalaxyPosition());
            if (from != null && from != to) {
                GL11.glPushMatrix();
                Matrix4f rotationMat = new Matrix4f();
                rotationMat.rotate(Minecraft.func_71410_x().field_71451_h.field_70177_z * ((float)Math.PI / 180), new Vector3f(0.0f, -1.0f, 0.0f));
                GL11.glEnable((int)3042);
                GL11.glPushMatrix();
                Vector4f pos = new Vector4f((float)((double)this.getClampedSize(from) + 0.25), 0.0f, 0.0f, 1.0f);
                Matrix4f.transform((Matrix4f)rotationMat, (Vector4f)pos, (Vector4f)pos);
                GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
                this.renderPlanet(from, viewerDistance);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glPolygonMode((int)1032, (int)6914);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                RenderUtils.rotateTo((Entity)Minecraft.func_71410_x().field_71451_h);
                GL11.glScaled((double)0.01, (double)0.01, (double)0.01);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                this.drawTravelingShips(galaxy, to);
                GL11.glTranslated((double)-9.0, (double)-9.0, (double)0.0);
                ClientProxy.holoIcons.renderIcon("arrow_right", 0, 0);
                GL11.glPopMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                GL11.glPushMatrix();
                pos = new Vector4f((float)(-((double)this.getClampedSize(to) + 0.25)), 0.0f, 0.0f, 1.0f);
                Matrix4f.transform((Matrix4f)rotationMat, (Vector4f)pos, (Vector4f)pos);
                GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
                this.renderPlanet(to, viewerDistance);
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            } else {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                GL11.glPushMatrix();
                this.renderPlanet(to, viewerDistance);
                GL11.glPopMatrix();
            }
            GL11.glPolygonMode((int)1032, (int)6914);
            GL11.glEnable((int)3553);
        }
    }

    protected void drawTravelingShips(Galaxy galaxy, Planet planet) {
        int heightCount = -24;
        for (TravelEvent travelEvent : galaxy.getTravelEvents()) {
            if (!travelEvent.getTo().equals(planet) || !((IShip)travelEvent.getShip().func_77973_b()).isOwner(travelEvent.getShip(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) continue;
            String time = MOStringHelper.formatRemainingTime(travelEvent.getTimeRemainning((World)Minecraft.func_71410_x().field_71441_e) / 20L);
            int width = this.fontRenderer.func_78256_a(time);
            RenderUtils.renderStack(-8, heightCount - 8, travelEvent.getShip());
            this.fontRenderer.func_78276_b(time, -width / 2, heightCount + 8, Reference.COLOR_HOLO.getColor());
            heightCount -= 26;
        }
    }

    @Override
    protected void drawPlanetInfoClose(Planet planet) {
    }

    @Override
    public void renderGUIInfo(Galaxy galaxy, SpaceBody spaceBody, TileEntityMachineStarMap starMap, float partialTicks, float opacity) {
        if (spaceBody instanceof Planet) {
            Planet planet = (Planet)spaceBody;
            int y = 0;
            for (ItemStack shipStack : planet.getFleet()) {
                if (!(shipStack.func_77973_b() instanceof IShip)) continue;
                IShip ship = (IShip)shipStack.func_77973_b();
                GuiColor shipColor = Reference.COLOR_HOLO;
                if (!ship.isOwner(shipStack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    shipColor = Reference.COLOR_HOLO_RED;
                }
                RenderUtils.renderStack(16, y - 16, shipStack);
                this.fontRenderer.func_78276_b(shipStack.func_82833_r(), 36, y - 10, shipColor.getColor());
                y -= 16;
            }
        }
    }

    @Override
    public boolean displayOnZoom(int zoom, SpaceBody spaceBody) {
        return zoom == 4;
    }
}

