/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.starmap;

import io.netty.buffer.ByteBuf;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import net.minecraft.nbt.NBTTagCompound;

public class GalacticPosition {
    private int quadrantID = -1;
    private int starID = -1;
    private int planetID = -1;

    public GalacticPosition() {
    }

    public GalacticPosition(int quadrantID, int starID, int planetID) {
        this.setPosition(quadrantID, starID, planetID);
    }

    public GalacticPosition(GalacticPosition other) {
        this.quadrantID = other.quadrantID;
        this.starID = other.starID;
        this.planetID = other.planetID;
    }

    public GalacticPosition(Star star) {
        this.starID = star.getId();
        if (star.getQuadrant() != null) {
            this.quadrantID = star.getQuadrant().getId();
        }
    }

    public GalacticPosition(Planet planet) {
        this.planetID = planet.getId();
        if (planet.getStar() != null) {
            this.starID = planet.getStar().getId();
            if (planet.getStar().getQuadrant() != null) {
                this.quadrantID = planet.getStar().getQuadrant().getId();
            }
        }
    }

    public GalacticPosition(Quadrant quadrant) {
        this.quadrantID = quadrant.getId();
    }

    public GalacticPosition(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public GalacticPosition(ByteBuf buf) {
        this.readFromBuffer(buf);
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("GalacticPositionPlanet", this.planetID);
        tagCompound.func_74768_a("GalacticPositionStar", this.starID);
        tagCompound.func_74768_a("GalacticPositionQuadrant", this.quadrantID);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_150297_b("GalacticPositionPlanet", 3)) {
            this.planetID = tagCompound.func_74762_e("GalacticPositionPlanet");
        }
        if (tagCompound.func_150297_b("GalacticPositionStar", 3)) {
            this.starID = tagCompound.func_74762_e("GalacticPositionStar");
        }
        if (tagCompound.func_150297_b("GalacticPositionQuadrant", 3)) {
            this.quadrantID = tagCompound.func_74762_e("GalacticPositionQuadrant");
        }
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeInt(this.planetID);
        buf.writeInt(this.starID);
        buf.writeInt(this.quadrantID);
    }

    public void readFromBuffer(ByteBuf buf) {
        this.planetID = buf.readInt();
        this.starID = buf.readInt();
        this.quadrantID = buf.readInt();
    }

    public boolean equals(Star star) {
        if (star != null && this.starID == star.getId()) {
            return this.quadrantID >= 0 && star.getQuadrant() != null && star.getQuadrant().getId() == this.quadrantID;
        }
        return false;
    }

    public boolean equals(Planet planet) {
        if (this.planetID == planet.getId()) {
            return this.equals(planet.getStar());
        }
        return false;
    }

    public boolean equals(Quadrant quadrant) {
        return this.quadrantID == quadrant.getId();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.hashCode() == this.hashCode()) {
            return true;
        }
        if (obj instanceof GalacticPosition) {
            return this.planetID == ((GalacticPosition)obj).planetID && this.starID == ((GalacticPosition)obj).starID && this.quadrantID == ((GalacticPosition)obj).quadrantID;
        }
        return false;
    }

    public int getStarID() {
        return this.starID;
    }

    public int getQuadrantID() {
        return this.quadrantID;
    }

    public int getPlanetID() {
        return this.planetID;
    }

    public int distanceToLY(Galaxy galaxy, GalacticPosition position) {
        Star fromStar = galaxy.getStar(this);
        Star toStar = galaxy.getStar(position);
        if (fromStar != null && toStar != null && fromStar != toStar) {
            return (int)(fromStar.getPosition().func_72438_d(toStar.getPosition()) * 8000.0);
        }
        return 0;
    }

    public int distanceToAU(Galaxy galaxy, GalacticPosition position) {
        Planet fromPlanet = galaxy.getPlanet(this);
        Planet toPlanet = galaxy.getPlanet(position);
        if (fromPlanet != null && toPlanet != null) {
            return (int)(Math.abs(fromPlanet.getOrbit() - toPlanet.getOrbit()) * 100.0f);
        }
        return 0;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void setPosition(int quadrantID, int starID, int planetID) {
        this.quadrantID = quadrantID;
        this.starID = starID;
        this.planetID = planetID;
    }
}

