/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.koresample.tree.block;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scottkillen.mod.koresample.tree.DefinesSapling;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class SaplingBlock
extends BlockSapling {
    public static final int CAPACITY = 8;
    private static final int METADATA_MASK = 7;
    private final ImmutableList<DefinesSapling> subBlocks;
    private final List<IIcon> subblockIcons;

    protected SaplingBlock(Collection<? extends DefinesSapling> subBlocks) {
        Preconditions.checkArgument((!subBlocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((subBlocks.size() <= 8 ? 1 : 0) != 0);
        this.subBlocks = ImmutableList.copyOf(subBlocks);
        this.subblockIcons = Lists.newArrayListWithCapacity((int)subBlocks.size());
        this.func_149663_c("sapling");
    }

    protected static String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(46) + 1);
    }

    private static int mask(int metadata) {
        return metadata & 7;
    }

    protected final List<DefinesSapling> subBlocks() {
        return Collections.unmodifiableList(this.subBlocks);
    }

    public final List<String> subBlockNames() {
        ArrayList names = Lists.newArrayListWithCapacity((int)this.subBlocks.size());
        for (DefinesSapling subBlock : this.subBlocks) {
            names.add(subBlock.speciesName());
        }
        return ImmutableList.copyOf((Collection)names);
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int unused, int metadata) {
        int index = SaplingBlock.mask(metadata);
        if (index < 0 || index >= this.subblockIcons.size()) {
            index = 0;
        }
        return this.subblockIcons.get(index);
    }

    public final void func_149878_d(World world, int x, int y, int z, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (int)x, (int)y, (int)z)) {
            return;
        }
        int metadata = SaplingBlock.mask(world.func_72805_g(x, y, z));
        WorldGenerator treeGen = ((DefinesSapling)this.subBlocks.get(metadata)).saplingTreeGenerator();
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 4);
        if (!treeGen.func_76484_a(world, rand, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)this, metadata, 4);
        }
    }

    public final int func_149692_a(int metadata) {
        return SaplingBlock.mask(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item item, CreativeTabs unused, List subBlocks) {
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            subBlocks.add(new ItemStack(item, 1, i));
        }
    }

    public final void func_149651_a(IIconRegister iconRegister) {
        this.subblockIcons.clear();
        for (int i = 0; i < this.subBlocks.size(); ++i) {
            String iconName = String.format("%ssapling_%s", this.resourcePrefix(), ((DefinesSapling)this.subBlocks.get(i)).speciesName());
            this.subblockIcons.add(i, iconRegister.func_94245_a(iconName));
        }
    }

    public final String func_149739_a() {
        return String.format("tile.%s%s", this.resourcePrefix(), SaplingBlock.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    protected abstract String resourcePrefix();

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("subBlocks", this.subBlocks).add("subblockIcons", this.subblockIcons).toString();
    }
}

