/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.core;

import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardentrees.block.BlockFlowerLeaves;
import com.jaquadro.minecraft.gardentrees.block.BlockGTSapling;
import com.jaquadro.minecraft.gardentrees.block.BlockIvy;
import com.jaquadro.minecraft.gardentrees.block.BlockStrangePlant;
import com.jaquadro.minecraft.gardentrees.block.BlockThinLog;
import com.jaquadro.minecraft.gardentrees.block.BlockThinLogFence;
import com.jaquadro.minecraft.gardentrees.block.tile.TileEntityWoodProxy;
import com.jaquadro.minecraft.gardentrees.item.ItemGTSapling;
import com.jaquadro.minecraft.gardentrees.item.ItemIvy;
import com.jaquadro.minecraft.gardentrees.item.ItemThinLog;
import com.jaquadro.minecraft.gardentrees.item.ItemThinLogFence;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import org.apache.logging.log4j.Level;

public class ModBlocks {
    public static BlockThinLog thinLog;
    public static BlockThinLogFence thinLogFence;
    public static BlockFlowerLeaves flowerLeaves;
    public static BlockGTSapling sapling;
    public static BlockIvy ivy;
    public static BlockStrangePlant strangePlant;

    public void init() {
        thinLog = new BlockThinLog(ModBlocks.makeName("thinLog"));
        thinLogFence = new BlockThinLogFence(ModBlocks.makeName("thinLogFence"));
        flowerLeaves = new BlockFlowerLeaves(ModBlocks.makeName("flowerLeaves"));
        sapling = new BlockGTSapling(ModBlocks.makeName("sapling"));
        ivy = new BlockIvy(ModBlocks.makeName("ivy"));
        strangePlant = new BlockStrangePlant(ModBlocks.makeName("strangePlant"));
        GameRegistry.registerBlock((Block)sapling, ItemGTSapling.class, (String)"sapling");
        GameRegistry.registerBlock((Block)thinLog, ItemThinLog.class, (String)"thin_log");
        GameRegistry.registerBlock((Block)thinLogFence, ItemThinLogFence.class, (String)"thin_log_fence");
        GameRegistry.registerBlock((Block)ivy, ItemIvy.class, (String)"ivy");
        GameRegistry.registerBlock((Block)strangePlant, (String)"strange_plant");
        GameRegistry.registerTileEntity(TileEntityWoodProxy.class, (String)ModBlocks.getQualifiedName((Block)thinLog));
    }

    public static String makeName(String name) {
        return "GardenTrees".toLowerCase() + "." + name;
    }

    public static Block get(String name) {
        return GameRegistry.findBlock((String)"GardenTrees", (String)name);
    }

    public static String getQualifiedName(Block block) {
        return GameData.getBlockRegistry().func_148750_c((Object)block);
    }

    public static UniqueMetaIdentifier getUniqueMetaID(Block block, int meta) {
        String name = GameData.getBlockRegistry().func_148750_c((Object)block);
        if (name == null) {
            FMLLog.log((String)"GardenTrees", (Level)Level.WARN, (String)"Tried to make a UniqueMetaIdentifier from an invalid block", (Object[])new Object[0]);
            return null;
        }
        return new UniqueMetaIdentifier(name, meta);
    }
}

