/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.block.tile;

import com.jaquadro.minecraft.gardenstuff.block.BlockBloomeryFurnace;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import com.jaquadro.minecraft.gardenstuff.core.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBloomeryFurnace
extends TileEntity
implements ISidedInventory {
    private static final int SLOT_PRIMARY = 0;
    private static final int SLOT_SECONDARY = 1;
    private static final int SLOT_FUEL = 2;
    private static final int SLOT_OUTPUT = 3;
    private static final int[] slots = new int[]{0, 1, 2, 3};
    private ItemStack[] furnaceItemStacks = new ItemStack[4];
    private String customName;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        int n = list.func_74745_c();
        for (int i = 0; i < n; ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.furnaceBurnTime = tag.func_74765_d("BurnTime");
        this.furnaceCookTime = tag.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityBloomeryFurnace.getItemBurnTime(this.furnaceItemStacks[2]);
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("CookTime", (short)this.furnaceCookTime);
        NBTTagList list = new NBTTagList();
        int n = this.furnaceItemStacks.length;
        for (int i = 0; i < n; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int ceiling) {
        return ceiling * this.furnaceCookTime / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int ceiling) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return ceiling * this.furnaceBurnTime / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void func_145845_h() {
        boolean hasPrevBurnTime = this.furnaceBurnTime > 0;
        boolean isDirty = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime != 0 || this.furnaceItemStacks[2] != null && this.furnaceItemStacks[0] != null && this.furnaceItemStacks[1] != null) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityBloomeryFurnace.getItemBurnTime(this.furnaceItemStacks[2]);
                    if (this.furnaceBurnTime > 0) {
                        isDirty = true;
                        if (this.furnaceItemStacks[2] != null) {
                            --this.furnaceItemStacks[2].field_77994_a;
                            if (this.furnaceItemStacks[2].field_77994_a == 0) {
                                this.furnaceItemStacks[2] = this.furnaceItemStacks[2].func_77973_b().getContainerItem(this.furnaceItemStacks[2]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        isDirty = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (hasPrevBurnTime != this.furnaceBurnTime > 0) {
                isDirty = true;
                BlockBloomeryFurnace.updateFurnaceBlockState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.furnaceBurnTime > 0);
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null || this.furnaceItemStacks[1] == null) {
            return false;
        }
        if (this.furnaceItemStacks[0].func_77973_b() != Items.field_151042_j && this.furnaceItemStacks[0].func_77973_b() != Item.func_150898_a((Block)Blocks.field_150366_p)) {
            return false;
        }
        if (this.furnaceItemStacks[1].func_77973_b() != Item.func_150898_a((Block)Blocks.field_150354_m)) {
            return false;
        }
        ItemStack itemOutput = new ItemStack(ModItems.wroughtIronIngot);
        if (this.furnaceItemStacks[3] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[3].func_77969_a(itemOutput)) {
            return false;
        }
        int result = this.furnaceItemStacks[3].field_77994_a + itemOutput.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[3].func_77976_d();
    }

    public void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        ItemStack itemOutput = new ItemStack(ModItems.wroughtIronIngot);
        if (this.furnaceItemStacks[3] == null) {
            this.furnaceItemStacks[3] = itemOutput.func_77946_l();
        } else if (this.furnaceItemStacks[3].func_77973_b() == itemOutput.func_77973_b()) {
            this.furnaceItemStacks[3].field_77994_a += itemOutput.field_77994_a;
        }
        --this.furnaceItemStacks[0].field_77994_a;
        --this.furnaceItemStacks[1].field_77994_a;
        if (this.furnaceItemStacks[0].field_77994_a <= 0) {
            this.furnaceItemStacks[0] = null;
        }
        if (this.furnaceItemStacks[1].field_77994_a <= 0) {
            this.furnaceItemStacks[1] = null;
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        Block block;
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) == ModBlocks.stoneBlock && stack.func_77960_j() == 0) {
            return ModBlocks.stoneBlock.getBurnTime(stack);
        }
        if (item == Items.field_151044_h && stack.func_77960_j() == 1) {
            return 1600;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityBloomeryFurnace.getItemBurnTime(stack) > 0;
    }

    public static boolean isItemPrimaryInput(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151042_j) {
            return true;
        }
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150366_p);
    }

    public static boolean isItemSecondaryInput(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m);
    }

    public int[] func_94128_d(int side) {
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 3;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.furnaceItemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this.furnaceItemStacks[slot] != null) {
            if (this.furnaceItemStacks[slot].field_77994_a <= count) {
                ItemStack stack = this.furnaceItemStacks[slot];
                this.furnaceItemStacks[slot] = null;
                return stack;
            }
            ItemStack stack = this.furnaceItemStacks[slot].func_77979_a(count);
            if (this.furnaceItemStacks[slot].field_77994_a == 0) {
                this.furnaceItemStacks[slot] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.furnaceItemStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.gardenstuff.bloomeryFurnace";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 3) {
            return false;
        }
        if (slot == 2) {
            return TileEntityBloomeryFurnace.isItemFuel(stack);
        }
        return true;
    }
}

