/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.util;

public class RenderHelperState {
    public double renderMinX;
    public double renderMinY;
    public double renderMinZ;
    public double renderMaxX;
    public double renderMaxY;
    public double renderMaxZ;
    public boolean flipTexture;
    public boolean renderFromInside;
    public boolean enableAO;
    public float shiftU;
    public float shiftV;
    public float colorMultYNeg;
    public float colorMultYPos;
    public float colorMultZNeg;
    public float colorMultZPos;
    public float colorMultXNeg;
    public float colorMultXPos;
    public int brightnessTopLeft;
    public int brightnessBottomLeft;
    public int brightnessBottomRight;
    public int brightnessTopRight;
    public final float[] colorTopLeft = new float[3];
    public final float[] colorBottomLeft = new float[3];
    public final float[] colorBottomRight = new float[3];
    public final float[] colorTopRight = new float[3];

    public RenderHelperState() {
        this.resetColorMult();
    }

    public void setRenderBounds(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        this.renderMinX = xMin;
        this.renderMinY = yMin;
        this.renderMinZ = zMin;
        this.renderMaxX = xMax;
        this.renderMaxY = yMax;
        this.renderMaxZ = zMax;
    }

    public void resetColorMult() {
        this.colorMultYNeg = 0.5f;
        this.colorMultYPos = 1.0f;
        this.colorMultZNeg = 0.8f;
        this.colorMultZPos = 0.8f;
        this.colorMultXNeg = 0.6f;
        this.colorMultXPos = 0.6f;
    }

    public void setTextureOffset(float u, float v) {
        this.shiftU = u;
        this.shiftV = v;
    }

    public void resetTextureOffset() {
        this.shiftU = 0.0f;
        this.shiftV = 0.0f;
    }

    public void setColor(float r, float g, float b) {
        this.colorTopLeft[0] = r;
        this.colorTopLeft[1] = g;
        this.colorTopLeft[2] = b;
        this.colorBottomLeft[0] = r;
        this.colorBottomLeft[1] = g;
        this.colorBottomLeft[2] = b;
        this.colorBottomRight[0] = r;
        this.colorBottomRight[1] = g;
        this.colorBottomRight[2] = b;
        this.colorTopRight[0] = r;
        this.colorTopRight[1] = g;
        this.colorTopRight[2] = b;
    }

    public void scaleColor(float[] color, float scale) {
        int i = 0;
        while (i < color.length) {
            int n = i++;
            color[n] = color[n] * scale;
        }
    }
}

