/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block.support;

import com.jaquadro.minecraft.gardencore.api.block.garden.IConnectionProfile;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class BasicConnectionProfile
implements IConnectionProfile {
    @Override
    public boolean isAttachedNeighbor(IBlockAccess blockAccess, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                return this.isAttachedNeighbor(blockAccess, x, y, z, x, y - 1, z);
            }
            case 1: {
                return this.isAttachedNeighbor(blockAccess, x, y, z, x, y + 1, z);
            }
            case 2: {
                return this.isAttachedNeighbor(blockAccess, x, y, z, x, y, z - 1);
            }
            case 3: {
                return this.isAttachedNeighbor(blockAccess, x, y, z, x, y, z + 1);
            }
            case 4: {
                return this.isAttachedNeighbor(blockAccess, x, y, z, x - 1, y, z);
            }
            case 5: {
                return this.isAttachedNeighbor(blockAccess, x, y, z, x + 1, y, z);
            }
        }
        return false;
    }

    @Override
    public boolean isAttachedNeighbor(IBlockAccess blockAccess, int x, int y, int z, int nx, int ny, int nz) {
        int nData;
        Block nBlock;
        if (y != ny || Math.abs(nx - x) > 1 || Math.abs(nz - z) > 1) {
            return false;
        }
        Block sBlock = blockAccess.func_147439_a(x, y, z);
        if (sBlock != (nBlock = blockAccess.func_147439_a(nx, ny, nz))) {
            return false;
        }
        int sData = blockAccess.func_72805_g(x, y, z);
        if (sData != (nData = blockAccess.func_72805_g(nx, ny, nz))) {
            return false;
        }
        TileEntity sEntity = blockAccess.func_147438_o(x, y, z);
        TileEntity nEntity = blockAccess.func_147438_o(nx, ny, nz);
        if (sEntity == null || nEntity == null || sEntity.getClass() != nEntity.getClass()) {
            return false;
        }
        return sEntity instanceof TileEntityGarden;
    }
}

