/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.proxies;

import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CommonProxy {
    private static String deathBackpack = "ironbackpacksPersistedPack";
    private static String currBackpack = "ironbackpacksCurrentPack";

    public static void saveBackpackOnDeath(EntityPlayer player) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack tempStack = player.field_71071_by.func_70301_a(i);
            if (tempStack == null || !UpgradeMethods.hasKeepOnDeathUpgrade(tempStack)) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            ItemStack stackToAdd = CommonProxy.removeKeepOnDeathUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(tempStack), tempStack);
            stackToAdd.func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
            player.field_71071_by.func_70299_a(i, null);
        }
        NBTTagCompound rootPersistentCompound = player.getEntityData().func_74775_l("PlayerPersisted");
        rootPersistentCompound.func_74782_a(deathBackpack, (NBTBase)tagList);
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)rootPersistentCompound);
        }
    }

    public static void loadBackpackOnDeath(EntityPlayer player) {
        NBTTagCompound rootPersistentCompound = player.getEntityData().func_74775_l("PlayerPersisted");
        if (rootPersistentCompound != null && rootPersistentCompound.func_74764_b(deathBackpack)) {
            NBTTagList tagList = rootPersistentCompound.func_150295_c(deathBackpack, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                player.field_71071_by.func_70441_a(ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i)));
            }
            rootPersistentCompound.func_82580_o(deathBackpack);
        }
    }

    private static ItemStack removeKeepOnDeathUpgrade(int[] upgrades, ItemStack stack) {
        if (stack != null) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            NBTTagList tagList = new NBTTagList();
            for (int upgrade : upgrades) {
                if (upgrade == 4) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Upgrade", (byte)upgrade);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            nbtTagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
            return stack;
        }
        return null;
    }

    public static void updateCurrBackpack(EntityPlayer player, ItemStack stack) {
        NBTTagCompound rootPersistentCompound = player.getEntityData().func_74775_l("PlayerPersisted");
        if (stack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.func_77955_b(tagCompound);
            rootPersistentCompound.func_74782_a(currBackpack, (NBTBase)tagCompound);
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)rootPersistentCompound);
            }
        } else {
            rootPersistentCompound.func_82580_o(currBackpack);
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)rootPersistentCompound);
            }
        }
    }

    public static ItemStack getCurrBackpack(EntityPlayer player) {
        NBTTagCompound rootPersistentCompound = player.getEntityData().func_74775_l("PlayerPersisted");
        if (rootPersistentCompound != null && rootPersistentCompound.func_74764_b(currBackpack)) {
            return ItemStack.func_77949_a((NBTTagCompound)rootPersistentCompound.func_74775_l(currBackpack));
        }
        return null;
    }
}

