/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.items.upgrades;

import java.util.ArrayList;
import main.ironbackpacks.client.gui.buttons.ButtonTypes;
import main.ironbackpacks.container.backpack.InventoryBackpack;
import main.ironbackpacks.items.backpacks.IronBackpackType;
import main.ironbackpacks.items.backpacks.ItemBaseBackpack;
import main.ironbackpacks.util.ConfigHandler;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class UpgradeMethods {
    public static boolean hasButtonUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 1) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasNestingUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 2) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasNestingAdvancedUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 15) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasRenamingUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        if (!ConfigHandler.renamingUpgradeRequired) {
            return true;
        }
        for (int upgrade : upgrades) {
            if (upgrade != 5) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasDamageBarUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 3) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterBasicUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 6) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterFuzzyUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 11) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterOreDictUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 12) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterModSpecificUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 7) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterAdvancedUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 14) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasHopperUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 8) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasCondenserUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 9) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasQuickDepositUpgrade(int[] upgrades) {
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 13) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasKeepOnDeathUpgrade(ItemStack stack) {
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(stack);
        boolean hasUpgrade = false;
        for (int upgrade : upgrades) {
            if (upgrade != 4) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static int getAlternateGuiUpgradesCount(int[] upgrades) {
        int numberOfUpgrades = 0;
        if (!ConfigHandler.renamingUpgradeRequired) {
            numberOfUpgrades = 1;
            for (int upgrade : upgrades) {
                if (upgrade != 6 && upgrade != 7 && upgrade != 11 && upgrade != 12 && upgrade != 8 && upgrade != 14 && upgrade != 9) continue;
                ++numberOfUpgrades;
            }
        } else {
            for (int upgrade : upgrades) {
                if (upgrade != 6 && upgrade != 7 && upgrade != 5 && upgrade != 14 && upgrade != 11 && upgrade != 12 && upgrade != 8 && upgrade != 9) continue;
                ++numberOfUpgrades;
            }
        }
        return numberOfUpgrades;
    }

    public static int getAlternateGuiUpgradeSlots(int[] upgrades) {
        int slots = 0;
        for (int upgrade : upgrades) {
            if (upgrade == 6 || upgrade == 7 || upgrade == 11 || upgrade == 12 || upgrade == 8 || upgrade == 9) {
                slots += 9;
                continue;
            }
            if (upgrade != 14) continue;
            slots += 9;
        }
        return slots;
    }

    public static int getAltGuiUpgradesUsed(int[] upgrades) {
        int counter = 0;
        if (!ConfigHandler.renamingUpgradeRequired) {
            for (int upgrade : upgrades) {
                if (upgrade != 6 && upgrade != 7 && upgrade != 11 && upgrade != 12 && upgrade != 8 && upgrade != 9 && upgrade != 14) continue;
                ++counter;
            }
        } else {
            for (int upgrade : upgrades) {
                if (upgrade != 6 && upgrade != 7 && upgrade != 5 && upgrade != 14 && upgrade != 11 && upgrade != 12 && upgrade != 8 && upgrade != 9) continue;
                ++counter;
            }
        }
        return counter;
    }

    public static ArrayList<ItemStack> getBasicFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterBasic")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterBasic", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getFuzzyFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterFuzzy")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterFuzzy", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getOreDictFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterOreDict")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterOreDict", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getModSpecificFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterModSpecific")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterModSpecific", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ItemStack[] getAdvFilterAllItems(ItemStack stack) {
        ItemStack[] advFilterStacks = new ItemStack[18];
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterAdvAllSlots")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterAdvAllSlots", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                advFilterStacks[stackTag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            }
        }
        return advFilterStacks;
    }

    public static byte[] getAdvFilterButtonStates(ItemStack stack) {
        byte[] advFilterButtonStates = new byte[18];
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterAdvButtons")) {
            byte[] bytes = ((NBTTagByteArray)nbtTagCompound.func_74781_a("FilterAdvButtons")).func_150292_c();
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == 0) {
                    bytes[i] = (byte)ButtonTypes.EXACT.getID();
                }
                advFilterButtonStates[i] = bytes[i];
            }
        }
        return advFilterButtonStates;
    }

    public static ArrayList<ItemStack> getAdvFilterBasicItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)ButtonTypes.EXACT.getID()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getAdvFilterFuzzyItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)ButtonTypes.FUZZY.getID()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getAdvFilterModSpecificItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)ButtonTypes.MOD_SPECIFIC.getID()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getAdvFilterOreDictItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)ButtonTypes.ORE_DICT.getID()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getHopperItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("Hopper")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Hopper", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getCondenserItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("Condenser")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Condenser", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static boolean transferFromBackpackToInventory(EntityPlayer player, ItemStack backpack, World world, int x, int y, int z) {
        IInventory inv;
        TileEntity targeted = world.func_147438_o(x, y, z);
        if (targeted != null && (inv = UpgradeMethods.getTargetedInventory(targeted)) != null) {
            return UpgradeMethods.transferItemsToContainer(player, backpack, inv);
        }
        return false;
    }

    private static IInventory getTargetedInventory(TileEntity tile) {
        if (tile == null || !(tile instanceof IInventory)) {
            return null;
        }
        return (IInventory)tile;
    }

    private static boolean transferItemsToContainer(EntityPlayer player, ItemStack backpack, IInventory transferTo) {
        boolean returnValue = false;
        IronBackpackType type = IronBackpackType.values()[((ItemBaseBackpack)backpack.func_77973_b()).getGuiId()];
        InventoryBackpack inventoryBackpack = new InventoryBackpack(player, backpack, type);
        if (transferTo.func_70302_i_() > 0 && !inventoryBackpack.isEmpty()) {
            for (int i = 0; i < inventoryBackpack.func_70302_i_(); ++i) {
                ItemStack stackToMove = inventoryBackpack.func_70301_a(i);
                if (stackToMove == null || stackToMove.field_77994_a <= 0) continue;
                ItemStack remainder = UpgradeMethods.putInFirstValidSlot(transferTo, stackToMove);
                inventoryBackpack.func_70299_a(i, remainder);
                inventoryBackpack.onGuiSaved(player);
                returnValue = true;
            }
        }
        return returnValue;
    }

    private static ItemStack putInFirstValidSlot(IInventory transferTo, ItemStack stackToTransfer) {
        for (int i = 0; i < transferTo.func_70302_i_(); ++i) {
            ItemStack tempStack = transferTo.func_70301_a(i);
            if (tempStack == null) {
                if (!transferTo.func_94041_b(i, stackToTransfer)) continue;
                transferTo.func_70299_a(i, stackToTransfer);
                transferTo.func_70296_d();
                return null;
            }
            if (tempStack.field_77994_a <= 0 || !tempStack.func_77969_a(stackToTransfer) || tempStack.field_77994_a >= tempStack.func_77976_d() || !ItemStack.func_77970_a((ItemStack)tempStack, (ItemStack)stackToTransfer)) continue;
            int amountToResupply = tempStack.func_77976_d() - tempStack.field_77994_a;
            if (stackToTransfer.field_77994_a >= amountToResupply) {
                transferTo.func_70299_a(i, new ItemStack(tempStack.func_77973_b(), tempStack.func_77976_d(), tempStack.func_77960_j()));
                transferTo.func_70296_d();
                int oldStackSize = stackToTransfer.field_77994_a;
                stackToTransfer.field_77994_a = oldStackSize - amountToResupply;
                continue;
            }
            transferTo.func_70299_a(i, new ItemStack(tempStack.func_77973_b(), tempStack.field_77994_a + stackToTransfer.field_77994_a, tempStack.func_77960_j()));
            transferTo.func_70296_d();
            return null;
        }
        return stackToTransfer;
    }
}

