/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.items.backpacks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import main.ironbackpacks.IronBackpacks;
import main.ironbackpacks.items.ItemBase;
import main.ironbackpacks.items.backpacks.IronBackpackType;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.proxies.CommonProxy;
import main.ironbackpacks.util.ConfigHandler;
import main.ironbackpacks.util.IronBackpacksConstants;
import main.ironbackpacks.util.IronBackpacksHelper;
import main.ironbackpacks.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemBaseBackpack
extends ItemBase {
    private int guiId;
    private int typeID;
    private int upgradeSlots;
    private boolean openAltGui;

    public ItemBaseBackpack(String unlocName, String textureName, int upgradeSlots, int ID) {
        super(unlocName, textureName);
        this.func_77625_d(1);
        this.upgradeSlots = upgradeSlots;
        this.guiId = ID - 1;
        this.typeID = ID;
        this.openAltGui = true;
    }

    public int getTypeId() {
        return this.typeID;
    }

    public int getGuiId() {
        return this.guiId;
    }

    public int getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(stack);
        return UpgradeMethods.hasDamageBarUpgrade(upgrades);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getFullness(stack);
    }

    public double getFullness(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        int total = 0;
        int full = 0;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("Items")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
            ItemStack[] inventory = new ItemStack[IronBackpackType.values()[this.guiId].getSize()];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                byte j = stackTag.func_74771_c("Slot");
                if (i < 0 || i > inventory.length) continue;
                inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            }
            for (ItemStack tempStack : inventory) {
                if (tempStack != null) {
                    full += tempStack.field_77994_a;
                    total += tempStack.func_77976_d();
                    continue;
                }
                total += 64;
            }
        }
        return 1.0 - (double)full / (double)total;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            CommonProxy.updateCurrBackpack(player, itemStack);
            return itemStack;
        }
        NBTHelper.setUUID(itemStack);
        CommonProxy.updateCurrBackpack(player, itemStack);
        if (!player.func_70093_af()) {
            player.openGui((Object)IronBackpacks.instance, this.guiId, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return itemStack;
        }
        if (this.openAltGui) {
            player.openGui((Object)IronBackpacks.instance, this.guiId * -1 - 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else {
            this.openAltGui = true;
        }
        return itemStack;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                return false;
            }
            if (UpgradeMethods.hasQuickDepositUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(itemstack))) {
                this.openAltGui = !UpgradeMethods.transferFromBackpackToInventory(player, itemstack, world, x, y, z);
                return !this.openAltGui;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(itemStack);
        int totalUpgradePoints = IronBackpacksHelper.getTotalUpgradePointsFromNBT(itemStack);
        if (Keyboard.isKeyDown((int)42)) {
            int tierUpgradeCount;
            int upgradesUsed = 0;
            for (int upgrade : upgrades) {
                list.add(IronBackpacksConstants.Upgrades.LOCALIZED_NAMES[upgrade]);
                upgradesUsed += IronBackpacksConstants.Upgrades.UPGRADE_POINTS[upgrade];
            }
            if (upgrades.length > 0) {
                list.add("");
            }
            list.add(upgradesUsed + "/" + totalUpgradePoints + " upgrade points used.");
            list.add(UpgradeMethods.getAltGuiUpgradesUsed(upgrades) + "/" + IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED + " alternate gui upgrades used.");
            if (ConfigHandler.renamingUpgradeRequired) {
                list.add("(The " + IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED + "th upgrade must include the renaming upgrade)");
            }
            if ((tierUpgradeCount = ConfigHandler.additionalUpgradesLimit + this.getGuiId()) > 0) {
                list.add(IronBackpacksHelper.getAdditionalUpgradesTimesApplied(itemStack) * ConfigHandler.additionalUpgradesIncrease + "/" + tierUpgradeCount * ConfigHandler.additionalUpgradesIncrease + " additional upgrade points added.");
            }
        } else if (totalUpgradePoints > 0) {
            list.add("Hold shift for more info.");
        }
    }
}

