/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import main.ironbackpacks.container.backpack.ContainerBackpack;
import main.ironbackpacks.container.backpack.InventoryBackpack;
import main.ironbackpacks.items.backpacks.IronBackpackType;
import main.ironbackpacks.items.backpacks.ItemBaseBackpack;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.proxies.CommonProxy;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ForgeEventHandler {
    @SubscribeEvent
    public void onItemPickupEvent(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ArrayList<ArrayList<ItemStack>> backpacks = this.getFilterCondenserAndHopperBackpacks(event.entityPlayer);
        boolean doFilter = this.checkHopperUpgrade(event, backpacks.get(2));
        if (doFilter) {
            this.checkFilterUpgrade(event, backpacks.get(0));
        }
        this.checkCondenserUpgrade(event, backpacks.get(1));
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            CommonProxy.saveBackpackOnDeath((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            CommonProxy.loadBackpackOnDeath((EntityPlayer)event.entity);
        }
    }

    private ArrayList<ArrayList<ItemStack>> getFilterCondenserAndHopperBackpacks(EntityPlayer player) {
        ArrayList<ItemStack> filterBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> condenserBackpacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> hopperBackpacks = new ArrayList<ItemStack>();
        ArrayList<ArrayList<ItemStack>> returnArray = new ArrayList<ArrayList<ItemStack>>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemBaseBackpack)) continue;
            ItemStack backpack = player.field_71071_by.func_70301_a(i);
            int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(backpack);
            if (UpgradeMethods.hasFilterBasicUpgrade(upgrades) || UpgradeMethods.hasFilterModSpecificUpgrade(upgrades) || UpgradeMethods.hasFilterFuzzyUpgrade(upgrades) || UpgradeMethods.hasFilterOreDictUpgrade(upgrades) || UpgradeMethods.hasFilterAdvancedUpgrade(upgrades)) {
                filterBackpacks.add(backpack);
            }
            if (UpgradeMethods.hasCondenserUpgrade(upgrades)) {
                condenserBackpacks.add(backpack);
            }
            if (!UpgradeMethods.hasHopperUpgrade(upgrades)) continue;
            hopperBackpacks.add(backpack);
        }
        returnArray.add(filterBackpacks);
        returnArray.add(condenserBackpacks);
        returnArray.add(hopperBackpacks);
        return returnArray;
    }

    private boolean checkHopperUpgrade(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks) {
        boolean doFilter = true;
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                IronBackpackType type = IronBackpackType.values()[((ItemBaseBackpack)backpack.func_77973_b()).getGuiId()];
                ContainerBackpack container = new ContainerBackpack(event.entityPlayer, new InventoryBackpack(event.entityPlayer, backpack, type), type);
                if (!(event.entityPlayer.field_71070_bA instanceof ContainerBackpack)) {
                    ArrayList<ItemStack> hopperItems = UpgradeMethods.getHopperItems(backpack);
                    block1: for (ItemStack hopperItem : hopperItems) {
                        if (hopperItem == null) continue;
                        boolean foundSlot = false;
                        ItemStack stackToResupply = null;
                        Slot slotToResupply = null;
                        for (int i = type.getSize(); i < type.getSize() + 36; ++i) {
                            ItemStack tempItem;
                            Slot tempSlot = container.func_75139_a(i);
                            if (tempSlot == null || !tempSlot.func_75216_d() || !(tempItem = tempSlot.func_75211_c()).func_77969_a(hopperItem) || tempItem.field_77994_a >= tempItem.func_77976_d()) continue;
                            foundSlot = true;
                            slotToResupply = tempSlot;
                            stackToResupply = tempItem;
                            break;
                        }
                        if (!foundSlot) continue;
                        boolean done = false;
                        if (event.item.func_92059_d().func_77969_a(stackToResupply)) {
                            int amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                            if (event.item.func_92059_d().field_77994_a >= amountToResupply) {
                                event.item.func_92058_a(new ItemStack(event.item.func_92059_d().func_77973_b(), event.item.func_92059_d().field_77994_a - amountToResupply, event.item.func_92059_d().func_77960_j()));
                                slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77960_j()));
                                done = true;
                            } else {
                                doFilter = false;
                            }
                        }
                        if (done) continue;
                        for (int i = 0; i < type.getSize(); ++i) {
                            int amountToResupply;
                            ItemStack tempItem;
                            Slot tempSlot = container.func_75139_a(i);
                            if (tempSlot == null || !tempSlot.func_75216_d() || !(tempItem = tempSlot.func_75211_c()).func_77969_a(stackToResupply)) continue;
                            if (event.item.func_92059_d().func_77969_a(stackToResupply)) {
                                amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a - event.item.func_92059_d().field_77994_a;
                                if (tempItem.field_77994_a >= amountToResupply) {
                                    tempSlot.func_75209_a(amountToResupply);
                                    slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d() - event.item.func_92059_d().field_77994_a, stackToResupply.func_77960_j()));
                                    continue block1;
                                }
                                tempSlot.func_75209_a(tempItem.field_77994_a);
                                slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.field_77994_a + tempItem.field_77994_a, stackToResupply.func_77960_j()));
                                continue;
                            }
                            amountToResupply = stackToResupply.func_77976_d() - stackToResupply.field_77994_a;
                            if (tempItem.field_77994_a >= amountToResupply) {
                                tempSlot.func_75209_a(amountToResupply);
                                slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.func_77976_d(), stackToResupply.func_77960_j()));
                                continue block1;
                            }
                            tempSlot.func_75209_a(tempItem.field_77994_a);
                            slotToResupply.func_75215_d(new ItemStack(stackToResupply.func_77973_b(), stackToResupply.field_77994_a + tempItem.field_77994_a, stackToResupply.func_77960_j()));
                        }
                    }
                }
                container.sort();
                container.func_75134_a(event.entityPlayer);
            }
        }
        return doFilter;
    }

    private void checkCondenserUpgrade(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks) {
        if (!backpackStacks.isEmpty()) {
            CraftingManager craftingManager = CraftingManager.func_77594_a();
            for (ItemStack backpack : backpackStacks) {
                if (event.entityPlayer.field_71070_bA instanceof ContainerBackpack) continue;
                IronBackpackType type = IronBackpackType.values()[((ItemBaseBackpack)backpack.func_77973_b()).getGuiId()];
                ContainerBackpack container = new ContainerBackpack(event.entityPlayer, new InventoryBackpack(event.entityPlayer, backpack, type), type);
                ContainerWorkbench containerWorkbench = new ContainerWorkbench(event.entityPlayer.field_71071_by, event.item.field_70170_p, 0, 0, 0);
                InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)containerWorkbench, 3, 3);
                ArrayList<ItemStack> condenserItems = UpgradeMethods.getCondenserItems(backpack);
                for (ItemStack condenserItem : condenserItems) {
                    if (condenserItem == null) continue;
                    for (int index = 0; index < type.getSize(); ++index) {
                        ItemStack theStack;
                        Slot theSlot = container.func_75139_a(index);
                        if (theSlot == null || !theSlot.func_75216_d() || (theStack = theSlot.func_75211_c()) == null || theStack.field_77994_a < 9 || !theStack.func_77969_a(condenserItem)) continue;
                        ItemStack myStack = new ItemStack(theStack.func_77973_b(), 1, theStack.func_77960_j());
                        for (int i = 0; i < 9; ++i) {
                            inventoryCrafting.func_70299_a(i, myStack);
                        }
                        ItemStack recipeOutput = craftingManager.func_82787_a(inventoryCrafting, event.item.field_70170_p);
                        if (recipeOutput == null) continue;
                        int numberOfIterations = (int)Math.floor(theStack.field_77994_a / 9);
                        ItemStack myRecipeOutput = new ItemStack(recipeOutput.func_77973_b(), numberOfIterations, recipeOutput.func_77960_j());
                        if (container.transferStackInSlot(myRecipeOutput) != null) {
                            theSlot.func_75209_a(theStack.field_77994_a - theStack.field_77994_a % 9);
                        }
                        container.save(event.entityPlayer);
                    }
                }
                container.sort();
                container.func_75134_a(event.entityPlayer);
            }
        }
    }

    private void checkFilterUpgrade(EntityItemPickupEvent event, ArrayList<ItemStack> backpackStacks) {
        if (!backpackStacks.isEmpty()) {
            for (ItemStack backpack : backpackStacks) {
                IronBackpackType type = IronBackpackType.values()[((ItemBaseBackpack)backpack.func_77973_b()).getGuiId()];
                ContainerBackpack container = new ContainerBackpack(event.entityPlayer, new InventoryBackpack(event.entityPlayer, backpack, type), type);
                if (!(event.entityPlayer.field_71070_bA instanceof ContainerBackpack)) {
                    int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(backpack);
                    if (UpgradeMethods.hasFilterBasicUpgrade(upgrades)) {
                        this.transferWithBasicFilter(UpgradeMethods.getBasicFilterItems(backpack), event, container);
                    }
                    if (UpgradeMethods.hasFilterModSpecificUpgrade(upgrades)) {
                        this.transferWithModSpecificFilter(UpgradeMethods.getModSpecificFilterItems(backpack), event, container);
                    }
                    if (UpgradeMethods.hasFilterFuzzyUpgrade(upgrades)) {
                        this.transferWithFuzzyFilter(UpgradeMethods.getFuzzyFilterItems(backpack), event, container);
                    }
                    if (UpgradeMethods.hasFilterOreDictUpgrade(upgrades)) {
                        this.transferWithOreDictFilter(UpgradeMethods.getOreDictFilterItems(backpack), this.getOreDict(event.item.func_92059_d()), event, container);
                    }
                    if (UpgradeMethods.hasFilterAdvancedUpgrade(upgrades)) {
                        ItemStack[] advFilterItems = UpgradeMethods.getAdvFilterAllItems(backpack);
                        byte[] advFilterButtonStates = UpgradeMethods.getAdvFilterButtonStates(backpack);
                        this.transferWithBasicFilter(UpgradeMethods.getAdvFilterBasicItems(advFilterItems, advFilterButtonStates), event, container);
                        this.transferWithModSpecificFilter(UpgradeMethods.getAdvFilterModSpecificItems(advFilterItems, advFilterButtonStates), event, container);
                        this.transferWithFuzzyFilter(UpgradeMethods.getAdvFilterFuzzyItems(advFilterItems, advFilterButtonStates), event, container);
                        this.transferWithOreDictFilter(UpgradeMethods.getAdvFilterOreDictItems(advFilterItems, advFilterButtonStates), this.getOreDict(event.item.func_92059_d()), event, container);
                    }
                }
                container.func_75134_a(event.entityPlayer);
            }
        }
    }

    private void transferWithBasicFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null || !event.item.func_92059_d().func_77969_a(filterItem)) continue;
            container.transferStackInSlot(event.item.func_92059_d());
        }
    }

    private void transferWithFuzzyFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null || event.item.func_92059_d().func_77973_b() != filterItem.func_77973_b()) continue;
            container.transferStackInSlot(event.item.func_92059_d());
        }
    }

    private void transferWithOreDictFilter(ArrayList<ItemStack> filterItems, ArrayList<String> itemEntityOre, EntityItemPickupEvent event, ContainerBackpack container) {
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null) continue;
            ArrayList<String> filterItemOre = this.getOreDict(filterItem);
            if (itemEntityOre == null || filterItemOre == null) continue;
            for (String oreName : itemEntityOre) {
                if (!filterItemOre.contains(oreName)) continue;
                container.transferStackInSlot(event.item.func_92059_d());
            }
        }
    }

    private void transferWithModSpecificFilter(ArrayList<ItemStack> filterItems, EntityItemPickupEvent event, ContainerBackpack container) {
        for (ItemStack filterItem : filterItems) {
            if (filterItem == null || !this.getModName(event.item.func_92059_d()).equals(this.getModName(filterItem))) continue;
            container.transferStackInSlot(event.item.func_92059_d());
        }
    }

    private String getModName(ItemStack itemStack) {
        String entityUnlocName = itemStack.func_77977_a().substring(5);
        if (entityUnlocName.contains(":")) {
            return entityUnlocName.split(":")[0];
        }
        return "vanilla";
    }

    private ArrayList<String> getOreDict(ItemStack itemStack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
        ArrayList<String> retList = new ArrayList<String>();
        if (ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0 && !retList.contains(OreDictionary.getOreName((int)ids[i]))) {
                    retList.add(OreDictionary.getOreName((int)ids[i]));
                    continue;
                }
                retList.add(OreDictionary.getOreName((int)ids[i]));
            }
        }
        return retList.isEmpty() ? null : retList;
    }
}

