/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.crafting;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import main.ironbackpacks.crafting.BackpackTierRecipe;
import main.ironbackpacks.crafting.BackpackUpgradeRecipe;
import main.ironbackpacks.items.ItemRegistry;
import main.ironbackpacks.util.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ItemRecipeRegistry {
    private static String[] oreNames = OreDictionary.getOreNames();
    private static List ores = Arrays.asList(oreNames);

    public static void registerItemRecipes() {
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.basicBackpack, ConfigHandler.basicBackpackRecipe);
        ItemRecipeRegistry.registerUpgradeRecipes();
        ItemRecipeRegistry.registerMiscRecipes();
        RecipeSorter.register((String)"BackpackUpgrade", BackpackUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"BackpackTier", BackpackTierRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        ItemRecipeRegistry.registerBackpackUpgradeRecipes();
        ItemRecipeRegistry.registerBackpackTierRecipes();
    }

    private static void registerMiscRecipes() {
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.nest, ConfigHandler.nestRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.upgradeCore, ConfigHandler.upgradeCoreRecipe);
        ItemRecipeRegistry.registerShapelessRecipe(ItemRegistry.jeweledFeather, ConfigHandler.jeweledFeatherRecipe);
        ItemRecipeRegistry.registerShapelessRecipe(ItemRegistry.treatedLeather, ConfigHandler.treatedLeatherRecipe);
    }

    private static void registerUpgradeRecipes() {
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.buttonUpgrade, ConfigHandler.buttonUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.nestingUpgrade, ConfigHandler.nestingUpgradeRecipe);
        if (ConfigHandler.renamingUpgradeRequired) {
            ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.renamingUpgrade, ConfigHandler.renamingUpgradeRecipe);
        }
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.damageBarUpgrade, ConfigHandler.damageBarUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.filterBasicUpgrade, ConfigHandler.filterBasicUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.filterFuzzyUpgrade, ConfigHandler.filterFuzzyUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.filterOreDictUpgrade, ConfigHandler.filterOreDictUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.filterModSpecificUpgrade, ConfigHandler.filterModSpecificUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.hopperUpgrade, ConfigHandler.hopperUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.condenserUpgrade, ConfigHandler.condenserUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.keepOnDeathUpgrade, ConfigHandler.keepOnDeathUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.additionalUpgradesUpgrade, ConfigHandler.additionalUpgradesUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.quickDepositUpgrade, ConfigHandler.quickDepositUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.filterAdvancedUpgrade, ConfigHandler.filterAdvancedUpgradeRecipe);
        ItemRecipeRegistry.registerBasicRecipe(ItemRegistry.nestingAdvancedUpgrade, ConfigHandler.nestingAdvancedUpgradeRecipe);
    }

    private static void registerBackpackUpgradeRecipes() {
        ArrayList<Item> backpacks = ItemRegistry.getBackpacks();
        ArrayList<Item> upgrades = ItemRegistry.getUpgrades();
        for (Item backpack : backpacks) {
            for (Item upgrade : upgrades) {
                GameRegistry.addRecipe((IRecipe)new BackpackUpgradeRecipe(new ItemStack(backpack), new ItemStack(upgrade), new ItemStack(backpack)));
            }
        }
    }

    private static void registerBackpackTierRecipes() {
        ArrayList<Item> backpacks = ItemRegistry.getBackpacks();
        String[] ironBackpackRecipe = ConfigHandler.ironBackpackRecipe;
        String[] goldBackpackRecipe = ConfigHandler.goldBackpackRecipe;
        String[] diamondBackpackRecipe = ConfigHandler.diamondBackpackRecipe;
        String[][] recipes = new String[][]{ironBackpackRecipe, goldBackpackRecipe, diamondBackpackRecipe};
        for (int i = 1; i < backpacks.size(); ++i) {
            Object[] theRecipe = ItemRecipeRegistry.getOreRecipe(recipes[i - 1]);
            GameRegistry.addRecipe((IRecipe)new BackpackTierRecipe(new ItemStack(backpacks.get(i)), theRecipe));
        }
    }

    private static void registerBasicRecipe(Item output, String[] recipe) {
        ItemRecipeRegistry.registerBasicOreRecipe(output, recipe);
    }

    private static void registerShapelessRecipe(Item output, String[] recipe) {
        Object[] theRecipe = ItemRecipeRegistry.getShapelessOreRecipe(recipe);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(output), theRecipe));
    }

    private static void registerBasicOreRecipe(Item output, String[] recipe) {
        Object[] theRecipe = ItemRecipeRegistry.getOreRecipe(recipe);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(output), theRecipe));
    }

    private static Object[] getOreRecipe(String[] input) {
        Object[] returnArray = ItemRecipeRegistry.initOreArray(input);
        for (int i = 0; i < input.length * 2; ++i) {
            returnArray[3 + i] = i % 2 == 0 ? Character.valueOf((char)(48 + i / 2)) : (input[i / 2].trim().equals("none") ? "none" : (ItemRecipeRegistry.isOreDict(input[i / 2].trim()) ? input[i / 2].trim() : (ItemRecipeRegistry.isItem(input[i / 2].trim()) ? ItemRecipeRegistry.getItem(input[i / 2].trim()) : ItemRecipeRegistry.getBlock(input[i / 2].trim()))));
        }
        return returnArray;
    }

    private static Object[] getShapelessOreRecipe(String[] input) {
        Object[] returnArray = new Object[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (input[i].contains(";")) {
                String[] splitString = input[i].split(";");
                if (ItemRecipeRegistry.isItem(splitString[0])) {
                    returnArray[i] = new ItemStack(ItemRecipeRegistry.getItem(splitString[0]), 1, Integer.valueOf(splitString[1]).intValue());
                    continue;
                }
                returnArray[i] = new ItemStack(ItemRecipeRegistry.getBlock(splitString[0]), 1, Integer.valueOf(splitString[1]).intValue());
                continue;
            }
            returnArray[i] = ItemRecipeRegistry.isOreDict(input[i].trim()) ? input[i].trim() : (ItemRecipeRegistry.isItem(input[i].trim()) ? ItemRecipeRegistry.getItem(input[i].trim()) : ItemRecipeRegistry.getBlock(input[i].trim()));
        }
        return returnArray;
    }

    private static Object[] initOreArray(String[] input) {
        Object[] array = new Object[21];
        for (int j = 0; j < 3; ++j) {
            String theChunk = "";
            for (int i = 0; i < 3; ++i) {
                theChunk = input[j * 3 + i].trim().equals("none") ? theChunk + " " : theChunk + Integer.toString(j * 3 + i);
            }
            array[j] = theChunk;
        }
        return array;
    }

    private static boolean isOreDict(String input) {
        return ores.contains(input.trim());
    }

    private static boolean isItem(String item) {
        if (item.contains(".")) {
            String[] splitString = item.split("\\.");
            if (splitString[0].equals("items")) {
                return true;
            }
            if (splitString[0].equals("blocks")) {
                return false;
            }
        }
        return false;
    }

    private static Item getItem(String item) {
        if (item.contains(".")) {
            String[] splitString = item.split("\\.");
            return (Item)Item.field_150901_e.func_82594_a(splitString[1]);
        }
        return null;
    }

    private static Block getBlock(String item) {
        if (item.contains(".")) {
            String[] splitString = item.split("\\.");
            return (Block)Block.field_149771_c.func_82594_a(splitString[1]);
        }
        return null;
    }
}

