/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.crafting;

import main.ironbackpacks.items.backpacks.ItemBaseBackpack;
import main.ironbackpacks.items.upgrades.ItemUpgradeBase;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.ConfigHandler;
import main.ironbackpacks.util.IronBackpacksConstants;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BackpackUpgradeRecipe
extends ShapelessOreRecipe {
    private final ItemStack recipeOutput;

    public BackpackUpgradeRecipe(ItemStack recipeOutput, Object ... items) {
        super(recipeOutput, items);
        this.recipeOutput = recipeOutput;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        NBTTagCompound nbtTagCompound;
        ItemStack backpack = BackpackUpgradeRecipe.getFirstBackpack(inventoryCrafting);
        ItemStack result = backpack.func_77946_l();
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(result);
        int totalUpgradePoints = IronBackpacksHelper.getTotalUpgradePointsFromNBT(result);
        ItemStack upgradeToApply = BackpackUpgradeRecipe.getFirstUpgrade(inventoryCrafting);
        ItemUpgradeBase upgradeToApplyBase = null;
        if (upgradeToApply != null) {
            upgradeToApplyBase = (ItemUpgradeBase)upgradeToApply.func_77973_b();
        }
        if ((nbtTagCompound = result.func_77978_p()) == null) {
            nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            result.func_77982_d(nbtTagCompound);
        }
        boolean upgradeFound = false;
        NBTTagList tagList = new NBTTagList();
        if (totalUpgradePoints != 0 && upgradeToApplyBase != null) {
            if (upgrades.length == 0) {
                if (upgradeToApplyBase.getTypeID() == 10) {
                    upgradeFound = this.applyAdditional(nbtTagCompound, result);
                } else if (IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradePoints() <= totalUpgradePoints) {
                    if (IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getTypeID())) {
                        nbtTagCompound.func_74782_a("Added", (NBTBase)new NBTTagInt(IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.indexOf(upgradeToApplyBase.getTypeID())));
                    }
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    tagCompound.func_74774_a("Upgrade", (byte)upgradeToApplyBase.getTypeID());
                    tagList.func_74742_a((NBTBase)tagCompound);
                    upgradeFound = true;
                }
            } else {
                if (upgradeToApplyBase.getTypeID() == 10) {
                    upgradeFound = this.applyAdditional(nbtTagCompound, result);
                }
                for (int upgrade : upgrades) {
                    if (!upgradeFound && this.shouldRemove(upgradeToApplyBase, upgrade)) {
                        upgradeFound = true;
                        if (!IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getTypeID())) continue;
                        nbtTagCompound.func_74782_a("Removed", (NBTBase)new NBTTagInt(IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.indexOf(upgradeToApplyBase.getTypeID())));
                        continue;
                    }
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    tagCompound.func_74774_a("Upgrade", (byte)upgrade);
                    tagList.func_74742_a((NBTBase)tagCompound);
                }
                if (!upgradeFound && upgradeToApplyBase.getTypeID() != 10 && this.canApplyUpgrade(upgradeToApplyBase, upgrades, totalUpgradePoints)) {
                    if (IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getTypeID())) {
                        nbtTagCompound.func_74782_a("Added", (NBTBase)new NBTTagInt(IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.indexOf(upgradeToApplyBase.getTypeID())));
                    }
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    tagCompound.func_74774_a("Upgrade", (byte)upgradeToApplyBase.getTypeID());
                    tagList.func_74742_a((NBTBase)tagCompound);
                    upgradeFound = true;
                }
            }
        } else if (upgradeToApplyBase != null && upgradeToApplyBase.getTypeID() == 10) {
            upgradeFound = this.applyAdditional(nbtTagCompound, result);
        }
        nbtTagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
        if (upgradeFound) {
            return result;
        }
        return null;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    private static ItemStack getFirstBackpack(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.func_70463_b(j, i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof ItemBaseBackpack)) continue;
                return itemstack;
            }
        }
        return null;
    }

    private static ItemStack getFirstUpgrade(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.func_70463_b(j, i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof ItemUpgradeBase)) continue;
                return itemstack;
            }
        }
        return null;
    }

    private boolean canApplyUpgrade(ItemUpgradeBase upgradeToApplyBase, int[] upgrades, int totalUpgradePoints) {
        if (IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getTypeID())) {
            if (UpgradeMethods.getAltGuiUpgradesUsed(upgrades) + 1 <= IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED) {
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradePoints() <= totalUpgradePoints;
            }
            return false;
        }
        if (upgradeToApplyBase.getTypeID() == 15 || upgradeToApplyBase.getTypeID() == 2) {
            if (upgradeToApplyBase.getTypeID() == 15) {
                for (int upgrade : upgrades) {
                    if (upgrade != 2) continue;
                    return false;
                }
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradePoints() <= totalUpgradePoints;
            }
            for (int upgrade : upgrades) {
                if (upgrade != 15) continue;
                return false;
            }
            return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradePoints() <= totalUpgradePoints;
        }
        return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradePoints() <= totalUpgradePoints;
    }

    private boolean applyAdditional(NBTTagCompound nbtTagCompound, ItemStack backpack) {
        ItemBaseBackpack backpackBase = (ItemBaseBackpack)backpack.func_77973_b();
        if (backpackBase == null) {
            return false;
        }
        if (nbtTagCompound.func_74764_b("AdditionalPoints")) {
            int[] oldValuesArray = nbtTagCompound.func_74759_k("AdditionalPoints");
            if (oldValuesArray[1] < ConfigHandler.additionalUpgradesLimit + backpackBase.getGuiId()) {
                oldValuesArray[1] = oldValuesArray[1] + 1;
                nbtTagCompound.func_74782_a("AdditionalPoints", (NBTBase)new NBTTagIntArray(new int[]{ConfigHandler.additionalUpgradesIncrease + oldValuesArray[0], oldValuesArray[1]}));
                return true;
            }
        } else if (ConfigHandler.additionalUpgradesLimit + backpackBase.getGuiId() > 0) {
            nbtTagCompound.func_74782_a("AdditionalPoints", (NBTBase)new NBTTagIntArray(new int[]{ConfigHandler.additionalUpgradesIncrease, 1}));
            return true;
        }
        return false;
    }

    private boolean shouldRemove(ItemUpgradeBase upgradeToApplyBase, int currUpgrade) {
        return upgradeToApplyBase.getTypeID() == currUpgrade;
    }
}

