/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.client.gui.inventory;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import main.ironbackpacks.client.gui.buttons.ButtonTypes;
import main.ironbackpacks.client.gui.buttons.TooltipButton;
import main.ironbackpacks.container.alternateGui.ContainerAlternateGui;
import main.ironbackpacks.container.alternateGui.InventoryAlternateGui;
import main.ironbackpacks.container.slot.GhostSlot;
import main.ironbackpacks.items.backpacks.IronBackpackType;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.network.AdvFilterTypesMessage;
import main.ironbackpacks.network.NetworkingHandler;
import main.ironbackpacks.network.RenameMessage;
import main.ironbackpacks.network.SingleByteMessage;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIBackpackAlternate
extends GuiContainer {
    private GUI type;
    private ContainerAlternateGui container;
    private EntityPlayer player;
    private GuiTextField textField;
    private TooltipButton renameButton;
    private TooltipButton moveLeft;
    private TooltipButton moveRight;
    private ArrayList<TooltipButton> advFilters = new ArrayList();
    private ArrayList<TooltipButton> tooltipButtons = new ArrayList();
    private TooltipButton[] rowIndeces = new TooltipButton[3];
    private long prevSystemTime;
    private int hoverTime;
    private boolean hasButtonUpgrade;
    private boolean hasNoUpgrades;
    private boolean hasRenamingUpgrade;
    private boolean hasFilterBasicUpgrade;
    private boolean hasFilterFuzzyUpgrade;
    private boolean hasFilterOreDictUpgrade;
    private boolean hasFilterModSpecificUpgrade;
    private boolean hasHopperUpgrade;
    private boolean hasCondenserUpgrade;
    private boolean hasFilterAdvancedUpgrade;

    private GUIBackpackAlternate(GUI type, EntityPlayer player, InventoryAlternateGui inv, int[] upgrades, IronBackpackType backpackType) {
        super(type.makeContainer(player, inv));
        this.player = player;
        this.container = (ContainerAlternateGui)type.makeContainer(player, inv);
        this.type = type;
        this.field_146999_f = type.xSize;
        this.field_147000_g = type.ySize;
        this.hasNoUpgrades = type.equals((Object)GUI.ZERO);
        this.hasButtonUpgrade = UpgradeMethods.hasButtonUpgrade(upgrades);
        this.hasRenamingUpgrade = UpgradeMethods.hasRenamingUpgrade(upgrades);
        this.hasFilterBasicUpgrade = UpgradeMethods.hasFilterBasicUpgrade(upgrades);
        this.hasFilterFuzzyUpgrade = UpgradeMethods.hasFilterFuzzyUpgrade(upgrades);
        this.hasFilterOreDictUpgrade = UpgradeMethods.hasFilterOreDictUpgrade(upgrades);
        this.hasFilterModSpecificUpgrade = UpgradeMethods.hasFilterModSpecificUpgrade(upgrades);
        this.hasHopperUpgrade = UpgradeMethods.hasHopperUpgrade(upgrades);
        this.hasCondenserUpgrade = UpgradeMethods.hasCondenserUpgrade(upgrades);
        this.hasFilterAdvancedUpgrade = UpgradeMethods.hasFilterAdvancedUpgrade(upgrades);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.hasRenamingUpgrade) {
            this.field_146291_p = true;
            this.textField = new GuiTextField(this.field_146289_q, xStart + 20, yStart + 21, 103, 12);
            this.textField.func_146193_g(-1);
            this.textField.func_146204_h(-1);
            this.textField.func_146203_f(29);
            Keyboard.enableRepeatEvents((boolean)true);
        }
        this.drawButtons();
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(((GUI)this.type).guiResourceList.location);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x + 12, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawInfoStrings();
        this.drawHoveringOverTooltipButton(mouseX, mouseY);
    }

    private void drawButtons() {
        this.field_146292_n.clear();
        this.tooltipButtons.clear();
        Arrays.fill(this.rowIndeces, null);
        int rowIndex = 0;
        if (this.hasRenamingUpgrade) {
            int xStart = (this.field_146294_l - this.field_146999_f) / 2;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            this.renameButton = new TooltipButton(ButtonTypes.RENAME, xStart + this.field_146999_f - 57, yStart + 22);
            this.field_146292_n.add(this.renameButton);
            this.tooltipButtons.add(this.renameButton);
        }
        int yStartButton = (this.field_146295_m - this.field_147000_g) / 2 + (this.hasRenamingUpgrade ? 40 : 21);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f - 12 - 19;
        if (this.hasButtonUpgrade) {
            if (this.hasFilterBasicUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, ButtonTypes.CLEAR_ROW, xStart, yStartButton, "Clears the basic", "filter items.");
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasFilterFuzzyUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, ButtonTypes.CLEAR_ROW, xStart, yStartButton, "Clears the fuzzy", "filter items.");
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasFilterOreDictUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, ButtonTypes.CLEAR_ROW, xStart, yStartButton, "Clears the ore dictionary", "filter items.");
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasFilterModSpecificUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, ButtonTypes.CLEAR_ROW, xStart, yStartButton, "Clears the mod specific", "filter items.");
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
        }
        if (this.hasFilterAdvancedUpgrade) {
            TooltipButton temp;
            this.moveLeft = new TooltipButton(ButtonTypes.MOVE_LEFT, this.field_147003_i + 15, yStartButton + 17);
            this.field_146292_n.add(this.moveLeft);
            this.moveRight = new TooltipButton(ButtonTypes.MOVE_RIGHT, xStart + 12, yStartButton + 17);
            this.field_146292_n.add(this.moveRight);
            this.tooltipButtons.add(this.moveLeft);
            this.tooltipButtons.add(this.moveRight);
            this.advFilters.clear();
            int xPositionStart = 20;
            if (this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint() + 9 > 18) {
                int i;
                int overlap = 9 - (18 - this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint());
                for (i = this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint(); i < 18; ++i) {
                    temp = new TooltipButton(ButtonTypes.buttonTypesArray[this.container.getInventoryAlternateGui().getAdvFilterButtonStates()[i] - 1], this.field_147003_i + xPositionStart, yStartButton + 31);
                    this.field_146292_n.add(temp);
                    this.advFilters.add(temp);
                    this.tooltipButtons.add(temp);
                    xPositionStart += 18;
                }
                for (i = 0; i < overlap; ++i) {
                    temp = new TooltipButton(ButtonTypes.buttonTypesArray[this.container.getInventoryAlternateGui().getAdvFilterButtonStates()[i] - 1], this.field_147003_i + xPositionStart, yStartButton + 31);
                    this.field_146292_n.add(temp);
                    this.advFilters.add(temp);
                    this.tooltipButtons.add(temp);
                    xPositionStart += 18;
                }
            } else {
                for (int i = this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint(); i < this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint() + 9; ++i) {
                    temp = new TooltipButton(ButtonTypes.buttonTypesArray[this.container.getInventoryAlternateGui().getAdvFilterButtonStates()[i] - 1], this.field_147003_i + xPositionStart, yStartButton + 31);
                    this.field_146292_n.add(temp);
                    this.advFilters.add(temp);
                    this.tooltipButtons.add(temp);
                    xPositionStart += 18;
                }
            }
            if (this.hasButtonUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, ButtonTypes.CLEAR_ROW, xStart, yStartButton, "Resets the advanced", "filter (clears items", "and button filters).");
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
            }
            yStartButton += 36;
        }
        if (this.hasButtonUpgrade) {
            if (this.hasHopperUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, ButtonTypes.CLEAR_ROW, xStart, yStartButton, "Clears the", "restocking items.");
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasCondenserUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, ButtonTypes.CLEAR_ROW, xStart, yStartButton, "Clears the", "crafting items.");
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
            }
        }
        for (int i = 0; i <= rowIndex; ++i) {
            if (this.rowIndeces[i] == null) continue;
            this.tooltipButtons.add(this.rowIndeces[i]);
        }
    }

    private void drawInfoStrings() {
        int yStart;
        ItemStack itemStack = IronBackpacksHelper.getBackpack(this.player);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)itemStack.func_82833_r()), 20, 6, 0x404040);
        int counter = this.hasFilterAdvancedUpgrade ? 5 : 4;
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"player.inventory"), 20, this.field_147000_g - 96 + counter, 0x404040);
        if (this.hasNoUpgrades) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"noValidUpgradesFound"), 20, 22, 0x404040);
        }
        int n = yStart = this.hasRenamingUpgrade ? 44 : 25;
        if (this.hasFilterBasicUpgrade) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"item.ironbackpacks:filterBasicUpgrade.name"), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterFuzzyUpgrade) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"item.ironbackpacks:filterFuzzyUpgrade.name"), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterOreDictUpgrade) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"item.ironbackpacks:filterOreDictUpgrade.name"), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterModSpecificUpgrade) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"item.ironbackpacks:filterModSpecificUpgrade.name"), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterAdvancedUpgrade) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"item.ironbackpacks:filterAdvancedUpgrade.name"), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasHopperUpgrade) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"item.ironbackpacks:hopperUpgrade.name"), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasCondenserUpgrade) {
            this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"item.ironbackpacks:condenserUpgrade.name"), 20, yStart, 0x404040);
        }
    }

    private void drawHoveringOverTooltipButton(int mouseX, int mouseY) {
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        TooltipButton curr = null;
        for (TooltipButton button : this.tooltipButtons) {
            if (button == null || !button.mouseInButton(mouseX, mouseY)) continue;
            curr = button;
            break;
        }
        if (curr != null) {
            if (curr.getHoverTime() == 0) {
                this.drawHoveringText(curr.getTooltip(), mouseX - w, mouseY - h, this.field_146289_q);
            } else {
                long systemTime = System.currentTimeMillis();
                if (this.prevSystemTime != 0L) {
                    this.hoverTime = (int)((long)this.hoverTime + (systemTime - this.prevSystemTime));
                }
                this.prevSystemTime = systemTime;
                if (this.hoverTime > curr.getHoverTime()) {
                    this.drawHoveringText(curr.getTooltip(), mouseX - w, mouseY - h, this.field_146289_q);
                }
            }
        } else {
            this.hoverTime = 0;
            this.prevSystemTime = 0L;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.renameButton) {
            String textToChangeTo = this.textField.func_146179_b();
            if (textToChangeTo.length() > 0) {
                this.container.renameBackpack(textToChangeTo);
                NetworkingHandler.network.sendToServer((IMessage)new RenameMessage(textToChangeTo));
                this.textField.func_146180_a("");
            }
        } else if (button == this.moveLeft) {
            this.container.changeAdvFilterSlots("left");
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(8));
            this.drawButtons();
        } else if (button == this.moveRight) {
            this.container.changeAdvFilterSlots("right");
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(9));
            this.drawButtons();
        } else if (this.advFilters.contains(button)) {
            byte slot = (byte)this.container.getWraparoundIndex(this.advFilters.indexOf(button));
            byte changeTo = (byte)TooltipButton.incrementType(button);
            this.container.setAdvFilterButtonType(slot, changeTo);
            NetworkingHandler.network.sendToServer((IMessage)new AdvFilterTypesMessage(slot, changeTo));
            this.drawButtons();
        } else if (button == this.rowIndeces[0]) {
            this.container.removeSlotsInRow(1);
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(1));
            this.drawButtons();
        } else if (button == this.rowIndeces[1]) {
            this.container.removeSlotsInRow(2);
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(2));
            this.drawButtons();
        } else if (button == this.rowIndeces[2]) {
            this.container.removeSlotsInRow(3);
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(3));
            this.drawButtons();
        }
    }

    protected void func_73869_a(char char1, int int1) {
        if (this.hasRenamingUpgrade) {
            if (!this.textField.func_146201_a(char1, int1)) {
                super.func_73869_a(char1, int1);
            }
        } else {
            super.func_73869_a(char1, int1);
        }
    }

    protected void func_73864_a(int int1, int int2, int int3) {
        super.func_73864_a(int1, int2, int3);
        if (this.hasRenamingUpgrade) {
            this.textField.func_146192_a(int1, int2, int3);
        }
    }

    public void func_73863_a(int int1, int int2, float float1) {
        super.func_73863_a(int1, int2, float1);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        if (this.hasRenamingUpgrade) {
            this.textField.func_146194_f();
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (this.hasFilterAdvancedUpgrade) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            for (int i = 0; i < 9; ++i) {
                int wheelState;
                GhostSlot slot = (GhostSlot)this.container.func_75139_a(this.container.getFilterAdvSlotIdStart() + i);
                if (!this.isMouseOverSlot(slot, x, y) || (wheelState = Mouse.getEventDWheel()) == 0) continue;
                if (wheelState / 120 == 1) {
                    this.container.changeAdvFilterSlots("right");
                    NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(9));
                    this.drawButtons();
                    continue;
                }
                this.container.changeAdvFilterSlots("left");
                NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(8));
                this.drawButtons();
            }
        }
    }

    private boolean isMouseOverSlot(Slot slot, int mPosX, int mPosY) {
        return (mPosX -= this.field_147003_i) >= slot.field_75223_e - 1 && mPosX < slot.field_75223_e + 16 + 1 && (mPosY -= this.field_147009_r) >= slot.field_75221_f - 1 && mPosY < slot.field_75221_f + 16 + 1;
    }

    public static enum GUI {
        ZERO(200, 132, ResourceList.ZERO),
        ONE(200, 150, ResourceList.ONE),
        TWO(200, 186, ResourceList.TWO),
        THREE(200, 222, ResourceList.THREE),
        RENAMING_ZERO(200, 132, ResourceList.ZERO),
        RENAMING_ONE(200, 168, ResourceList.RENAMING_ONE),
        RENAMING_TWO(200, 204, ResourceList.RENAMING_TWO),
        RENAMING_THREE(200, 240, ResourceList.RENAMING_THREE);

        private int xSize;
        private int ySize;
        private ResourceList guiResourceList;

        private GUI(int xSize, int ySize, ResourceList guiResourceList) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.guiResourceList = guiResourceList;
        }

        public static GUIBackpackAlternate buildGUIAlternate(EntityPlayer player, InventoryAlternateGui inv, int[] upgrades, IronBackpackType backpackType) {
            GUI gui = UpgradeMethods.hasRenamingUpgrade(upgrades) ? GUI.values()[UpgradeMethods.getAlternateGuiUpgradesCount(upgrades) + 3] : GUI.values()[UpgradeMethods.getAlternateGuiUpgradesCount(upgrades)];
            return new GUIBackpackAlternate(gui, player, inv, upgrades, backpackType);
        }

        private Container makeContainer(EntityPlayer player, InventoryAlternateGui inv) {
            return new ContainerAlternateGui(player, inv, this.xSize, this.ySize);
        }
    }

    public static enum ResourceList {
        ZERO(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/ZERO_alternateGui.png")),
        ONE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/ONE_alternateGui.png")),
        TWO(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/TWO_alternateGui.png")),
        THREE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/THREE_alternateGui.png")),
        RENAMING_ONE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/RENAMING_ONE_alternateGui.png")),
        RENAMING_TWO(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/RENAMING_TWO_alternateGui.png")),
        RENAMING_THREE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/RENAMING_THREE_alternateGui.png"));

        public final ResourceLocation location;

        private ResourceList(ResourceLocation loc) {
            this.location = loc;
        }
    }
}

