/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.client.gui.inventory;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import main.ironbackpacks.client.gui.buttons.ButtonTypes;
import main.ironbackpacks.client.gui.buttons.TooltipButton;
import main.ironbackpacks.container.backpack.ContainerBackpack;
import main.ironbackpacks.container.backpack.InventoryBackpack;
import main.ironbackpacks.items.backpacks.IronBackpackType;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.network.NetworkingHandler;
import main.ironbackpacks.network.SingleByteMessage;
import main.ironbackpacks.util.ConfigHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIBackpack
extends GuiContainer {
    private GUI type;
    private ContainerBackpack container;
    private ItemStack itemStack;
    private TooltipButton backpack_to_inventory_BUTTON;
    private TooltipButton inventory_to_backpack_BUTTON;
    private TooltipButton hotbar_to_backpack_BUTTON;
    private TooltipButton condense_backpack_BUTTON;
    private boolean hasAButtonUpgrade;
    private ArrayList<TooltipButton> tooltipButtons;
    private long prevSystemTime;
    private int hoverTime;

    private GUIBackpack(GUI type, EntityPlayer player, InventoryBackpack backpack, int[] upgrades, ItemStack itemStack) {
        super(type.makeContainer(player, backpack));
        this.container = (ContainerBackpack)type.makeContainer(player, backpack);
        this.type = type;
        this.field_146999_f = type.xSize;
        this.field_147000_g = type.ySize;
        this.field_146291_p = false;
        this.hasAButtonUpgrade = UpgradeMethods.hasButtonUpgrade(upgrades);
        this.itemStack = itemStack;
        this.tooltipButtons = new ArrayList();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.tooltipButtons.clear();
        if (this.hasAButtonUpgrade) {
            int xStart = (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f - 12;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2 + this.field_147000_g;
            this.backpack_to_inventory_BUTTON = new TooltipButton(ButtonTypes.BACKPACK_TO_INVENTORY, xStart - 20, yStart - 96);
            this.field_146292_n.add(this.backpack_to_inventory_BUTTON);
            this.hotbar_to_backpack_BUTTON = new TooltipButton(ButtonTypes.HOTBAR_TO_BACKPACK, xStart - 40, yStart - 96);
            this.field_146292_n.add(this.hotbar_to_backpack_BUTTON);
            this.inventory_to_backpack_BUTTON = new TooltipButton(ButtonTypes.INVENTORY_TO_BACKPACK, xStart - 60, yStart - 96);
            this.field_146292_n.add(this.inventory_to_backpack_BUTTON);
            this.condense_backpack_BUTTON = new TooltipButton(ButtonTypes.SORT_BACKPACK, xStart - 80, yStart - 96);
            this.field_146292_n.add(this.condense_backpack_BUTTON);
            this.tooltipButtons.add(this.backpack_to_inventory_BUTTON);
            this.tooltipButtons.add(this.hotbar_to_backpack_BUTTON);
            this.tooltipButtons.add(this.inventory_to_backpack_BUTTON);
            this.tooltipButtons.add(this.condense_backpack_BUTTON);
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(((GUI)this.type).guiResourceList.location);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x + 12, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)this.itemStack.func_82833_r()), 20, 6, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"player.inventory"), 20, this.field_147000_g - 96 + 2, 0x404040);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        TooltipButton curr = null;
        for (TooltipButton button : this.tooltipButtons) {
            if (!button.mouseInButton(mouseX, mouseY)) continue;
            curr = button;
            break;
        }
        if (curr != null) {
            long systemTime = System.currentTimeMillis();
            if (this.prevSystemTime != 0L) {
                this.hoverTime = (int)((long)this.hoverTime + (systemTime - this.prevSystemTime));
            }
            this.prevSystemTime = systemTime;
            if (this.hoverTime > curr.getHoverTime()) {
                this.drawHoveringText(curr.getTooltip(), mouseX - k, mouseY - l, this.field_146289_q);
            }
        } else {
            this.hoverTime = 0;
            this.prevSystemTime = 0L;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.backpack_to_inventory_BUTTON) {
            this.container.backpackToInventory();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(4));
        } else if (button == this.inventory_to_backpack_BUTTON) {
            this.container.inventoryToBackpack();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(5));
        } else if (button == this.hotbar_to_backpack_BUTTON) {
            this.container.hotbarToBackpack();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(6));
        } else if (button == this.condense_backpack_BUTTON) {
            this.container.sort();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(7));
        }
    }

    public static enum GUI {
        BASIC(ConfigHandler.enumBasicBackpack.sizeX.getValue() == 9 ? 200 : 236, 114 + 18 * ConfigHandler.enumBasicBackpack.sizeY.getValue(), ResourceList.BASIC, IronBackpackType.BASIC),
        IRON(ConfigHandler.enumIronBackpack.sizeX.getValue() == 9 ? 200 : 236, 114 + 18 * ConfigHandler.enumIronBackpack.sizeY.getValue(), ResourceList.IRON, IronBackpackType.IRON),
        GOLD(ConfigHandler.enumGoldBackpack.sizeX.getValue() == 9 ? 200 : 236, 114 + 18 * ConfigHandler.enumGoldBackpack.sizeY.getValue(), ResourceList.GOLD, IronBackpackType.GOLD),
        DIAMOND(ConfigHandler.enumDiamondBackpack.sizeX.getValue() == 9 ? 200 : 236, 114 + 18 * ConfigHandler.enumDiamondBackpack.sizeY.getValue(), ResourceList.DIAMOND, IronBackpackType.DIAMOND);

        private int xSize;
        private int ySize;
        private ResourceList guiResourceList;
        private IronBackpackType mainType;

        private GUI(int xSize, int ySize, ResourceList guiResourceList, IronBackpackType mainType) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.guiResourceList = guiResourceList;
            this.mainType = mainType;
        }

        public static GUIBackpack buildGUI(EntityPlayer player, InventoryBackpack backpack, int[] upgrades, ItemStack itemStack) {
            return new GUIBackpack(GUI.values()[backpack.getType().ordinal()], player, backpack, upgrades, itemStack);
        }

        private Container makeContainer(EntityPlayer player, InventoryBackpack backpack) {
            return new ContainerBackpack(player, backpack, this.mainType, this.xSize, this.ySize);
        }
    }

    public static enum ResourceList {
        BASIC(new ResourceLocation("ironbackpacks", "textures/guis/backpacks/" + String.valueOf(ConfigHandler.enumBasicBackpack.sizeY.getValue()) + "RowsOf" + String.valueOf(ConfigHandler.enumBasicBackpack.sizeX.getValue()) + ".png")),
        IRON(new ResourceLocation("ironbackpacks", "textures/guis/backpacks/" + String.valueOf(ConfigHandler.enumIronBackpack.sizeY.getValue()) + "RowsOf" + String.valueOf(ConfigHandler.enumIronBackpack.sizeX.getValue()) + ".png")),
        GOLD(new ResourceLocation("ironbackpacks", "textures/guis/backpacks/" + String.valueOf(ConfigHandler.enumGoldBackpack.sizeY.getValue()) + "RowsOf" + String.valueOf(ConfigHandler.enumGoldBackpack.sizeX.getValue()) + ".png")),
        DIAMOND(new ResourceLocation("ironbackpacks", "textures/guis/backpacks/" + String.valueOf(ConfigHandler.enumDiamondBackpack.sizeY.getValue()) + "RowsOf" + String.valueOf(ConfigHandler.enumDiamondBackpack.sizeX.getValue()) + ".png"));

        public final ResourceLocation location;

        private ResourceList(ResourceLocation loc) {
            this.location = loc;
        }
    }
}

