/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;
import net.minecraft.client.Minecraft;

public class AnimationRenderer {
    private long startTime = -1L;
    private boolean clearFinished = false;
    private LinkedList<Animation> animations = new LinkedList();
    private List<ITransformable> tranformables = new ArrayList<ITransformable>();
    private List<Animation> toClear = new ArrayList<Animation>();

    public AnimationRenderer() {
        this.setStartTime();
    }

    public void setStartTime(long start) {
        this.startTime = start;
    }

    public void setStartTime() {
        this.setStartTime(System.currentTimeMillis());
    }

    public void setStartTick(long start) {
        this.setStartTime(System.currentTimeMillis() - (this.getWorldTime() - start) * 1000L / 20L);
    }

    public long getWorldTime() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            return Minecraft.func_71410_x().field_71441_e.func_82737_E();
        }
        return 0L;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public float getElapsedTicks() {
        return (float)((double)this.getElapsedTime() / 1000.0 * 20.0);
    }

    public void addAnimation(Animation animation) {
        this.animations.add(animation);
    }

    public void deleteAnimation(Animation animation) {
        this.animations.remove(animation);
    }

    public void clearAnimations() {
        this.animations.clear();
    }

    public void autoClearAnimations() {
        this.clearFinished = true;
    }

    public List<ITransformable> animate(Animation ... animations) {
        this.tranformables.clear();
        this.toClear.clear();
        if (animations == null || animations.length == 0) {
            return this.tranformables;
        }
        ITransformable tr = null;
        long elapsedTime = this.getElapsedTime();
        for (Animation animation : animations) {
            tr = animation.animate(elapsedTime);
            if (tr != null) {
                this.tranformables.add(tr);
            }
            if (!animation.isFinished() || !this.clearFinished) continue;
            this.toClear.add(animation);
        }
        return this.tranformables;
    }

    public List<ITransformable> animate() {
        List<ITransformable> anims = this.animate(this.animations.toArray(new Animation[0]));
        for (Animation animation : this.toClear) {
            this.animations.remove(animation);
        }
        return anims;
    }

    public void animate(Shape shape, Transformation animation) {
        if (shape == null) {
            return;
        }
        animation.transform(shape, this.getElapsedTime());
    }
}

