/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class UICheckBox
extends UIComponent<UICheckBox> {
    protected GuiIcon bgIcon;
    protected GuiIcon bgIconDisabled;
    protected GuiIcon cbDisabled;
    protected GuiIcon cbChecked;
    protected GuiIcon cbHovered;
    private String label;
    private boolean checked;

    public UICheckBox(MalisisGui gui, String label) {
        super(gui);
        int w = 0;
        if (label != null && !label.equals("")) {
            this.label = label;
            w = GuiRenderer.getStringWidth(label);
        }
        this.setSize(w + 11, 10);
        this.shape = new SimpleGuiShape();
        this.bgIcon = gui.getGuiTexture().getIcon(242, 32, 10, 10);
        this.bgIconDisabled = gui.getGuiTexture().getIcon(252, 32, 10, 10);
        this.cbDisabled = gui.getGuiTexture().getIcon(242, 42, 12, 10);
        this.cbChecked = gui.getGuiTexture().getIcon(242, 52, 12, 10);
        this.cbHovered = gui.getGuiTexture().getIcon(254, 42, 12, 10);
    }

    public UICheckBox(MalisisGui gui) {
        this(gui, null);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public UICheckBox setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(10, 10);
        this.shape.setPosition(1, 0);
        this.rp.icon.set((IIcon)(this.isDisabled() ? this.bgIconDisabled : this.bgIcon));
        renderer.drawShape(this.shape, this.rp);
        renderer.next();
        if (this.hovered) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glShadeModel((int)7425);
            this.rp.colorMultiplier.set(0xFFFFFF);
            this.rp.alpha.set(80);
            this.rp.useTexture.set(false);
            this.shape.resetState();
            this.shape.setSize(8, 8);
            this.shape.setPosition(2, 1);
            renderer.drawShape(this.shape, this.rp);
            renderer.next();
            GL11.glShadeModel((int)7424);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3553);
        }
        if (this.label != null) {
            renderer.drawText(this.label, 14, 2, 0x404040, false);
        }
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.checked) {
            if (this.isHovered() && !this.isDisabled()) {
                GL11.glEnable((int)3042);
            }
            this.rp.reset();
            this.shape.resetState();
            this.shape.setSize(12, 10);
            this.rp.icon.set((IIcon)(this.isDisabled() ? this.cbDisabled : (this.isHovered() ? this.cbHovered : this.cbChecked)));
            renderer.drawShape(this.shape, this.rp);
            renderer.next();
            if (this.isHovered() && !this.isDisabled()) {
                GL11.glDisable((int)3042);
            }
        }
    }

    @Override
    public boolean onClick(int x, int y) {
        if (this.fireEvent(new CheckEvent(this, !this.checked))) {
            this.checked = !this.checked;
        }
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!this.isFocused()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        if (keyCode == 57 && this.fireEvent(new CheckEvent(this, !this.checked))) {
            this.checked = !this.checked;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[ text=" + this.label + ", checked=" + this.checked + ", " + this.getPropertyString() + " ]";
    }

    public static class CheckEvent
    extends ComponentEvent.ValueChange<UICheckBox, Boolean> {
        public CheckEvent(UICheckBox component, boolean checked) {
            super(component, component.isChecked(), checked);
        }

        public boolean isChecked() {
            return (Boolean)this.newValue;
        }
    }
}

