/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.UISlot;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.message.InventoryActionMessage;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class MalisisGui
extends GuiScreen {
    public static GuiTexture BLOCK_TEXTURE = new GuiTexture(TextureMap.field_110575_b);
    public static GuiTexture ITEM_TEXTURE = new GuiTexture(TextureMap.field_110576_c);
    public static boolean cancelClose = false;
    protected GuiRenderer renderer = new GuiRenderer();
    private UIContainer screen = new UIContainer(this);
    protected boolean guiscreenBackground = true;
    protected int lastMouseX;
    protected int lastMouseY;
    protected long lastClickButton = -1L;
    protected long lastClickTime = 0L;
    protected MalisisInventoryContainer inventoryContainer;
    private AnimationRenderer ar = new AnimationRenderer();
    protected UIComponent hoveredComponent;
    protected UIComponent focusedComponent;
    protected boolean constructed = false;

    protected MalisisGui() {
        this.ar.autoClearAnimations();
        this.screen.setClipContent(false);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public abstract void construct();

    public void setInventoryContainer(MalisisInventoryContainer container) {
        this.inventoryContainer = container;
    }

    public MalisisInventoryContainer getInventoryContainer() {
        return this.inventoryContainer;
    }

    public GuiTexture getGuiTexture() {
        return this.renderer.getDefaultTexture();
    }

    public long getElapsedTime() {
        return this.ar.getElapsedTime();
    }

    protected void addToScreen(UIComponent component) {
        this.screen.add(component);
        component.onAddedToScreen();
    }

    public void clearScreen() {
        this.screen.removeAll();
    }

    public UIComponent getComponentAt(int x, int y) {
        UIComponent component = this.screen.getComponentAt(x, y);
        return component == this.screen ? null : component;
    }

    public void func_146274_d() {
        try {
            super.func_146274_d();
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
                UIComponent component = this.getComponentAt(mouseX, mouseY);
                if (component != null && !component.isDisabled()) {
                    component.onMouseMove(this.lastMouseX, this.lastMouseY, mouseX, mouseY);
                    component.setHovered(true);
                } else {
                    MalisisGui.setHoveredComponent(null, false);
                }
            }
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            int delta = Mouse.getEventDWheel();
            if (delta == 0) {
                return;
            }
            if (delta > 1) {
                delta = 1;
            } else if (delta < -1) {
                delta = -1;
            }
            UIComponent component = this.getComponentAt(mouseX, mouseY);
            if (component != null && !component.isDisabled()) {
                component.onScrollWheel(mouseX, mouseY, delta);
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        try {
            long time = System.currentTimeMillis();
            UIComponent component = this.getComponentAt(x, y);
            if (component != null && !component.isDisabled()) {
                component.onButtonPress(x, y, MouseButton.getButton(button));
                if ((long)button == this.lastClickButton && time - this.lastClickTime < 250L) {
                    component.onDoubleClick(x, y, MouseButton.getButton(button));
                    this.lastClickTime = 0L;
                }
                component.setFocused(true);
            } else {
                MalisisGui.setFocusedComponent(null, true);
                if (this.inventoryContainer != null && this.inventoryContainer.getPickedItemStack() != null) {
                    MalisisInventoryContainer.ActionType action = button == 1 ? MalisisInventoryContainer.ActionType.DROP_ONE : MalisisInventoryContainer.ActionType.DROP_STACK;
                    MalisisGui.sendAction(action, null, button);
                }
            }
            this.lastClickTime = time;
            this.lastClickButton = button;
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_146273_a(int x, int y, int button, long timer) {
        try {
            if (this.focusedComponent != null) {
                this.focusedComponent.onDrag(this.lastMouseX, this.lastMouseY, x, y, MouseButton.getButton(button));
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_146286_b(int x, int y, int button) {
        try {
            UIComponent component;
            if (this.inventoryContainer != null) {
                if (this.inventoryContainer.shouldResetDrag(button)) {
                    MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_RESET, null, 0);
                    UISlot.buttonRelased = false;
                    return;
                }
                if (this.inventoryContainer.shouldEndDrag(button)) {
                    MalisisGui.sendAction(MalisisInventoryContainer.ActionType.DRAG_END, null, 0);
                    return;
                }
            }
            if ((component = this.getComponentAt(x, y)) != null && !component.isDisabled()) {
                MouseButton mb = MouseButton.getButton(button);
                component.onButtonRelease(x, y, mb);
                if (component == this.focusedComponent) {
                    if (mb == MouseButton.LEFT) {
                        component.onClick(x, y);
                    } else if (mb == MouseButton.RIGHT) {
                        component.onRightClick(x, y);
                    }
                }
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    protected void func_73869_a(char keyChar, int keyCode) {
        try {
            if (this.focusedComponent != null && this.focusedComponent.onKeyTyped(keyChar, keyCode)) {
                return;
            }
            if (this.hoveredComponent != null && this.hoveredComponent.onKeyTyped(keyChar, keyCode)) {
                return;
            }
            if (MalisisGui.isGuiCloseKey(keyCode)) {
                this.close();
            }
            if (!MalisisCore.isObfEnv && MalisisGui.func_146271_m() && keyCode == 19 && MalisisGui.currentGui() != null) {
                this.screen.removeAll();
                this.construct();
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        int factor = this.renderer.updateGuiScale();
        if (this.renderer.isIgnoreScale()) {
            width *= factor;
            height *= factor;
        }
        super.func_146280_a(minecraft, width, height);
        this.screen.setSize(width, height);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.ar.animate();
        if (this.renderer.isIgnoreScale()) {
            mouseX = Mouse.getX();
            mouseY = this.field_146295_m - Mouse.getY() - 1;
        }
        this.update(mouseX, mouseY, partialTicks);
        if (this.guiscreenBackground) {
            this.func_146270_b(1);
        }
        RenderHelper.func_74520_c();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2896);
        this.renderer.drawScreen(this.screen, mouseX, mouseY, partialTicks);
        if (this.inventoryContainer != null) {
            ItemStack itemStack = this.inventoryContainer.getPickedItemStack();
            if (itemStack != null) {
                this.renderer.renderPickedItemStack(itemStack);
            } else if (this.hoveredComponent != null && this.hoveredComponent.isHovered()) {
                this.renderer.drawTooltip(this.hoveredComponent.getTooltip());
            }
        } else if (this.hoveredComponent != null && this.hoveredComponent.isHovered()) {
            this.renderer.drawTooltip(this.hoveredComponent.getTooltip());
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    public void update(int mouseX, int mouseY, float partialTick) {
    }

    public void updateGui() {
    }

    public void animate(Animation animation) {
        this.animate(animation, 0);
    }

    public void animate(Animation animation, int delay) {
        animation.setDelay((int)this.ar.getElapsedTicks() + delay);
        this.ar.addAnimation(animation);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void display() {
        this.display(false);
    }

    public void display(boolean cancelClose) {
        try {
            if (!this.constructed) {
                this.construct();
                this.constructed = true;
            }
            MalisisGui.cancelClose = cancelClose;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
        }
        catch (Exception e) {
            MalisisCore.message("A problem occured : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    public void close() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.field_146297_k.field_71439_g != null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.field_146297_k.func_147108_a((GuiScreen)null);
        this.field_146297_k.func_71381_h();
    }

    public void func_146281_b() {
        if (this.inventoryContainer != null) {
            this.inventoryContainer.func_75134_a((EntityPlayer)this.field_146297_k.field_71439_g);
        }
    }

    public static MalisisGui currentGui() {
        return MalisisGui.currentGui(MalisisGui.class);
    }

    public static <T extends MalisisGui> T currentGui(Class<T> type) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null || !(gui instanceof MalisisGui)) {
            return null;
        }
        try {
            return (T)((Object)((MalisisGui)((Object)type.cast(gui))));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static void sendAction(MalisisInventoryContainer.ActionType action, MalisisSlot slot, int code) {
        if (action == null || MalisisGui.currentGui() == null || MalisisGui.currentGui().inventoryContainer == null) {
            return;
        }
        int inventoryId = slot != null ? slot.getInventoryId() : 0;
        int slotNumber = slot != null ? slot.slotNumber : 0;
        MalisisGui.currentGui().inventoryContainer.handleAction(action, inventoryId, slotNumber, code);
        InventoryActionMessage.sendAction(action, inventoryId, slotNumber, code);
    }

    public static UIComponent getHoveredComponent() {
        return MalisisGui.currentGui() != null ? MalisisGui.currentGui().hoveredComponent : null;
    }

    public static boolean setHoveredComponent(UIComponent component, boolean hovered) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.hoveredComponent == component) {
            if (!hovered) {
                gui.hoveredComponent = null;
                return true;
            }
            return false;
        }
        if (gui.hoveredComponent != null) {
            gui.hoveredComponent.setHovered(false);
        }
        gui.hoveredComponent = component;
        return true;
    }

    public static UIComponent getFocusedComponent() {
        return MalisisGui.currentGui() != null ? MalisisGui.currentGui().focusedComponent : null;
    }

    public static boolean setFocusedComponent(UIComponent component, boolean focused) {
        MalisisGui gui = MalisisGui.currentGui();
        if (gui == null) {
            return false;
        }
        if (gui.focusedComponent == component) {
            if (!focused) {
                gui.focusedComponent = null;
                return true;
            }
            return false;
        }
        if (gui.focusedComponent != null) {
            gui.focusedComponent.setFocused(false);
        }
        gui.focusedComponent = component;
        return true;
    }

    public static void playSound(String name) {
        MalisisGui.playSound(name, 1.0f);
    }

    public static void playSound(String name, float level) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(name), (float)level));
    }

    public static boolean isGuiCloseKey(int keyCode) {
        MalisisGui gui = MalisisGui.currentGui();
        return keyCode == 1 || gui != null && gui.inventoryContainer != null && keyCode == gui.field_146297_k.field_71474_y.field_151445_Q.func_151463_i();
    }
}

