/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib.util;

import cpw.mods.fml.common.FMLLog;
import net.lomeli.lomlib.util.NBTUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemUtil {
    public static ItemStack getItem(String itemString, int meta, String itemClassLoc) {
        ItemStack item = null;
        try {
            String itemClass = itemClassLoc;
            Object obj = Class.forName(itemClass).getField(itemString).get(null);
            if (obj instanceof Item) {
                item = new ItemStack((Item)obj, 1, meta);
            } else if (obj instanceof ItemStack) {
                item = (ItemStack)obj;
            }
        }
        catch (Exception ex) {
            FMLLog.warning((String)("Could not retrieve item identified by: " + itemString), (Object[])new Object[0]);
        }
        return item;
    }

    public static ItemStack getItem(String itemString, String itemClassLoc) {
        ItemStack item = null;
        try {
            String itemClass = itemClassLoc;
            Object obj = Class.forName(itemClass).getField(itemString).get(null);
            if (obj instanceof Item) {
                item = new ItemStack((Item)obj);
            } else if (obj instanceof ItemStack) {
                item = (ItemStack)obj;
            }
        }
        catch (Exception ex) {
            FMLLog.warning((String)("Could not retrieve item identified by: " + itemString), (Object[])new Object[0]);
        }
        return item;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static void setBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, Block block, int metaData) {
        int j1;
        int k1;
        Block i1 = world.func_147439_a(x, y, z);
        if (i1.equals(Blocks.field_150433_aE) && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        } else if (!(i1 == Blocks.field_150395_bd || i1 == Blocks.field_150329_H || i1 == Blocks.field_150330_I || i1 != null && i1.isReplaceable((IBlockAccess)world, x, y, z))) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (stack.field_77994_a == 0) {
            return;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return;
        }
        if (y == 255 && block.func_149688_o().func_76220_a()) {
            return;
        }
        if (world.func_147472_a(block, x, y, z, false, side, (Entity)player, stack) && ItemUtil.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, block, k1 = block.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, j1 = metaData))) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), Block.field_149775_l.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            --stack.field_77994_a;
        }
    }

    public static boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, Block block, int metadata) {
        if (!world.func_147465_d(x, y, z, block, metadata, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z).equals(block)) {
            block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_149714_e(world, x, y, z, metadata);
        }
        return true;
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB) {
        return stackA == null ? stackB == null : stackB != null && ItemUtil.areItemsTheSame(stackA, stackB) && (!stackA.func_77981_g() || stackA.func_77960_j() == stackB.func_77960_j());
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return stackA == null ? stackB == null : stackB != null && ItemUtil.areItemsTheSame(stackA, stackB) && stackA.func_77960_j() == stackB.func_77960_j() && (!checkNBT || NBTUtil.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d));
    }

    public static boolean areItemsTheSame(ItemStack a, ItemStack b) {
        return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j();
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return null;
        }
        ItemStack stack = new ItemStack(item, stackSize);
        return stack;
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack == null) {
            return null;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.field_77994_a = stackSize;
        return retStack;
    }

    public static void dropItemStackIntoWorld(ItemStack stack, World world, double x, double y, double z, boolean velocity) {
        if (stack != null) {
            float x2 = 0.5f;
            float y2 = 0.0f;
            float z2 = 0.5f;
            if (velocity) {
                x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            }
            EntityItem entity = new EntityItem(world, x + (double)x2, y + (double)y2, z + (double)z2, stack.func_77946_l());
            if (velocity) {
                entity.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
                entity.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
                entity.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
            } else {
                entity.field_70181_x = -0.0500000007450581;
                entity.field_70159_w = 0.0;
                entity.field_70179_y = 0.0;
            }
            world.func_72838_d((Entity)entity);
        }
    }

    public static ItemStack createNewBook(String author, String title, String[] pageText) {
        ItemStack newBook = new ItemStack(Items.field_151164_bB);
        if (!newBook.func_77942_o()) {
            newBook.field_77990_d = new NBTTagCompound();
        }
        NBTUtil.setString(newBook, "author", author);
        NBTUtil.setString(newBook, "title", title);
        NBTTagList pages = new NBTTagList();
        for (int i = 0; i < pageText.length; ++i) {
            pages.func_74742_a((NBTBase)new NBTTagString("" + (i + 1)));
        }
        newBook.func_77983_a("pages", (NBTBase)pages);
        return newBook;
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean tryInsertStack(IInventory targetInventory, int slot, ItemStack stack, boolean canMerge) {
        if (targetInventory.func_94041_b(slot, stack)) {
            ItemStack targetStack = targetInventory.func_70301_a(slot);
            if (targetStack == null) {
                int limit = targetInventory.func_70297_j_();
                if (limit < stack.field_77994_a) {
                    targetInventory.func_70299_a(slot, stack.func_77979_a(limit));
                } else {
                    targetInventory.func_70299_a(slot, stack.func_77946_l());
                    stack.field_77994_a = 0;
                }
                return true;
            }
            if (canMerge && targetInventory.func_94041_b(slot, stack) && ItemUtil.canStacksMerge(stack, targetStack)) {
                int space = targetStack.func_77976_d() - targetStack.field_77994_a;
                int mergeAmount = Math.min(space, stack.field_77994_a);
                ItemStack copy = targetStack.func_77946_l();
                copy.field_77994_a += mergeAmount;
                targetInventory.func_70299_a(slot, copy);
                stack.field_77994_a -= mergeAmount;
                return true;
            }
        }
        return false;
    }
}

