/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.lomlib;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import net.lomeli.lomlib.core.CommandLomLib;
import net.lomeli.lomlib.core.Proxy;
import net.lomeli.lomlib.util.LogHelper;
import net.lomeli.lomlib.util.SimpleConfig;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="LomLib", name="LomLib", version="3.2.0", guiFactory="net.lomeli.lomlib.client.config.GuiConfigFactory")
public class LomLib {
    @Mod.Instance
    public static LomLib instance;
    @SidedProxy(clientSide="net.lomeli.lomlib.client.ProxyClient", serverSide="net.lomeli.lomlib.core.Proxy")
    public static Proxy proxy;
    public static LogHelper logger;
    public static boolean debug;
    public static boolean patreon;
    public static boolean slime;
    public static SimpleConfig config;

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandLomLib());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = new LogHelper("LomLib");
        config = new SimpleConfig("LomLib", new Configuration(event.getSuggestedConfigurationFile())){

            @Override
            public void loadConfig() {
                debug = this.getConfig().getBoolean("debugMode", "general", debug, "Will display different types of information when set to true. Useful for those who are using LomLib to develop their mods.");
                patreon = this.getConfig().getBoolean("patreon", "general", patreon, "Enable patreon reward.(Client-side only)");
                slime = this.getConfig().getBoolean("slimePistonRightClick", "general", slime, "Just a nice little feature where you can right-click pistons with slime balls to turn them into sticky pistons");
                if (this.getConfig().hasChanged()) {
                    this.getConfig().save();
                }
            }
        };
        config.loadConfig();
        proxy.doStuffPre();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.doStuffInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.doStuffPost();
    }

    static {
        debug = false;
        patreon = true;
        slime = false;
    }
}

