/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class IESaveData
extends WorldSavedData {
    private static IESaveData INSTANCE;
    public static final String dataName = "ImmersiveEngineering-SaveData";
    public static boolean loaded;

    public IESaveData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int[] savedDimensions;
        for (int dim : savedDimensions = nbt.func_74759_k("savedDimensions")) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList" + dim, 10);
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
            if (world == null) continue;
            ImmersiveNetHandler.INSTANCE.clearAllConnections((World)world);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con == null) continue;
                ImmersiveNetHandler.INSTANCE.addConnection((World)world, con.start, con);
            }
        }
        NBTTagList mineralList = nbt.func_150295_c("mineralDepletion", 10);
        ExcavatorHandler.mineralDepletion.clear();
        for (int i = 0; i < mineralList.func_74745_c(); ++i) {
            NBTTagCompound tag = mineralList.func_150305_b(i);
            DimensionChunkCoords coords = DimensionChunkCoords.readFromNBT(tag);
            if (coords == null) continue;
            ExcavatorHandler.mineralDepletion.put(coords, tag.func_74762_e("depletion"));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        Integer[] relDim = ImmersiveNetHandler.INSTANCE.getRelevantDimensions().toArray(new Integer[0]);
        int[] savedDimensions = new int[relDim.length];
        for (int ii = 0; ii < relDim.length; ++ii) {
            savedDimensions[ii] = relDim[ii];
        }
        nbt.func_74783_a("savedDimensions", savedDimensions);
        for (int dim : savedDimensions) {
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
            if (world == null) continue;
            NBTTagList connectionList = new NBTTagList();
            for (ImmersiveNetHandler.Connection con : ImmersiveNetHandler.INSTANCE.getAllConnections((World)world)) {
                connectionList.func_74742_a((NBTBase)con.writeToNBT());
            }
            nbt.func_74782_a("connectionList" + dim, (NBTBase)connectionList);
        }
        NBTTagList mineralList = new NBTTagList();
        for (Map.Entry<DimensionChunkCoords, Integer> e : ExcavatorHandler.mineralDepletion.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            NBTTagCompound tag = e.getKey().writeToNBT();
            tag.func_74768_a("depletion", e.getValue().intValue());
            mineralList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("mineralDepletion", (NBTBase)mineralList);
    }

    public static void setDirty(int dimension) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    public static void setInstance(int dimension, IESaveData in) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            INSTANCE = in;
        }
    }

    static {
        loaded = false;
    }
}

