/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.item.construct.abstracts;

import lumaceon.mods.clockworkphase.init.ModBlocks;
import lumaceon.mods.clockworkphase.item.ItemClockworkPhaseGeneric;
import lumaceon.mods.clockworkphase.item.construct.abstracts.IElemental;
import lumaceon.mods.clockworkphase.lib.Phases;
import lumaceon.mods.clockworkphase.lib.Ranges;
import lumaceon.mods.clockworkphase.proxy.ClientProxy;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ItemElementalAbstract
extends ItemClockworkPhaseGeneric
implements IElemental {
    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 24000;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        NBTHelper.setInteger(item, "elemtimer", 0);
        return true;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        int x = (int)Math.floor(entityItem.field_70165_t);
        int y = (int)Math.floor(entityItem.field_70163_u - 1.0);
        int z = (int)Math.floor(entityItem.field_70161_v);
        Block targetBlock = entityItem.field_70170_p.func_147439_a(x, y, z);
        boolean flag = true;
        if (targetBlock == null) {
            return false;
        }
        if (!targetBlock.equals(ModBlocks.celestialCompass) && !targetBlock.equals(ModBlocks.celestialCompassSub)) {
            return false;
        }
        int meta = entityItem.field_70170_p.func_72805_g(x, y, z);
        ForgeDirection direction = ForgeDirection.getOrientation((int)meta);
        for (int n = 0; n < 10 && flag; ++n) {
            if (entityItem.field_70170_p.func_147439_a(x, y, z) == null) {
                return false;
            }
            if (entityItem.field_70170_p.func_147439_a(x, y, z).equals(ModBlocks.celestialCompass)) {
                flag = false;
                continue;
            }
            meta = entityItem.field_70170_p.func_72805_g(x += direction.offsetX, y, z += direction.offsetZ);
            direction = ForgeDirection.getOrientation((int)meta);
        }
        this.handleElementization(entityItem, x, y, z);
        return false;
    }

    private void handleElementization(EntityItem item, int x, int y, int z) {
        double xDifference = item.field_70165_t - (double)x;
        double zDifference = item.field_70161_v - (double)z;
        if (Ranges.CELESTIAL_NULL[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_NULL[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.unelementize(item);
                return;
            }
        } else if (Ranges.CELESTIAL_LIFE[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_LIFE[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.LIFE, item);
                return;
            }
        } else if (Ranges.CELESTIAL_LIGHT[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_LIGHT[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.LIGHT, item);
                return;
            }
        } else if (Ranges.CELESTIAL_WATER[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_WATER[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.WATER, item);
                return;
            }
        } else if (Ranges.CELESTIAL_EARTH[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_EARTH[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.EARTH, item);
                return;
            }
        } else if (Ranges.CELESTIAL_AIR[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_AIR[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.AIR, item);
                return;
            }
        } else if (Ranges.CELESTIAL_FIRE[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_FIRE[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.FIRE, item);
                return;
            }
        } else if (Ranges.CELESTIAL_DARKNESS[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_DARKNESS[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.LUNAR, item);
                return;
            }
        } else if (Ranges.CELESTIAL_DEATH[0].isValueInclusivelyWithinRange(xDifference) && Ranges.CELESTIAL_DEATH[1].isValueInclusivelyWithinRange(zDifference)) {
            if (item.field_70170_p.field_72995_K) {
                ClientProxy.particleGenerator.SPAWNER.spawnElementizeParticle(item.field_70165_t, item.field_70163_u, item.field_70161_v);
            }
            if (NBTHelper.getInt(item.func_92059_d(), "elemtimer") > 200) {
                this.elementize(Phases.DEATH, item);
                return;
            }
        } else {
            return;
        }
        NBTHelper.setInteger(item.func_92059_d(), "elemtimer", NBTHelper.getInt(item.func_92059_d(), "elemtimer") + 1);
    }

    @Override
    public void elementize(Phases phase, EntityItem item) {
        NBTHelper.setInteger(item.func_92059_d(), "elemtimer", 0);
    }

    @Override
    public void unelementize(EntityItem item) {
        NBTHelper.setInteger(item.func_92059_d(), "elemtimer", 0);
    }
}

