/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.client.gui.container;

import lumaceon.mods.clockworkphase.client.gui.components.SlotClockworkCraft;
import lumaceon.mods.clockworkphase.inventory.InventoryClockworkAssembly;
import lumaceon.mods.clockworkphase.item.ItemTemporalMultitool;
import lumaceon.mods.clockworkphase.item.component.ItemClockwork;
import lumaceon.mods.clockworkphase.item.component.ItemMainspring;
import lumaceon.mods.clockworkphase.item.construct.abstracts.IClockwork;
import lumaceon.mods.clockworkphase.item.construct.pocketwatch.ItemPocketWatch;
import lumaceon.mods.clockworkphase.item.construct.pocketwatch.module.ItemModule;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ContainerClockworkAssemblyTableAssemble
extends Container {
    private InventoryClockworkAssembly matrix = new InventoryClockworkAssembly(this);
    private InventoryCraftResult result = new InventoryCraftResult();
    private World world;

    public ContainerClockworkAssemblyTableAssemble(InventoryPlayer ip, World world) {
        int x;
        this.world = world;
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)ip, x, 48 + x * 18, 232));
        }
        for (x = 0; x < 9; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.func_75146_a(new Slot((IInventory)ip, 9 + y + x * 3, 48 + x * 18, 174 + y * 18));
            }
        }
        this.func_75146_a(new Slot((IInventory)this.matrix, 0, 84, 75));
        this.func_75146_a(new Slot((IInventory)this.matrix, 1, 156, 75));
        this.func_75146_a(new SlotClockworkCraft((IInventory)this.result, this.matrix, 0, 120, 75));
        this.func_75130_a(this.matrix);
    }

    public void func_75130_a(IInventory p_75130_1_) {
        ItemStack result = this.getClockworkRecipe();
        if (result != null) {
            this.result.func_70299_a(0, result);
            return;
        }
        result = this.getMultitoolRecipe();
        if (result != null) {
            this.result.func_70299_a(0, result);
            return;
        }
        result = this.getPocketWatchRecipe();
        this.result.func_70299_a(0, result);
    }

    public ItemStack getClockworkRecipe() {
        boolean mainspring = false;
        boolean clockwork = false;
        boolean construct = false;
        boolean doubles = false;
        boolean alreadyContainsMainspring = false;
        boolean alreadyContainsClockwork = false;
        for (int i = 0; i < 2; ++i) {
            ItemStack item = this.matrix.func_70301_a(i);
            if (item == null) {
                return null;
            }
            if (item.func_77973_b() instanceof IClockwork) {
                if (construct) {
                    doubles = true;
                }
                construct = true;
                if (NBTHelper.getInt(item, "max_tension") != 0) {
                    alreadyContainsMainspring = true;
                }
                if (!NBTHelper.hasTag(item, "cp_clockwork")) continue;
                alreadyContainsClockwork = true;
                continue;
            }
            if (item.func_77973_b() instanceof ItemMainspring) {
                if (mainspring) {
                    doubles = true;
                }
                mainspring = true;
                continue;
            }
            if (item.func_77973_b() instanceof ItemClockwork) {
                if (clockwork) {
                    doubles = true;
                }
                clockwork = true;
                continue;
            }
            return null;
        }
        if (alreadyContainsMainspring && mainspring) {
            return null;
        }
        if (alreadyContainsClockwork && clockwork) {
            return null;
        }
        if (doubles) {
            return null;
        }
        if ((mainspring || clockwork) && construct) {
            return this.constructResult();
        }
        return null;
    }

    private ItemStack constructResult() {
        ItemStack mainspring = null;
        ItemStack clockwork = null;
        ItemStack construct = null;
        for (int n = 0; n < this.matrix.func_70302_i_(); ++n) {
            ItemStack tempItem = this.matrix.func_70301_a(n);
            if (tempItem == null) continue;
            if (tempItem.func_77973_b() instanceof ItemMainspring) {
                mainspring = tempItem.func_77946_l();
            }
            if (tempItem.func_77973_b() instanceof ItemClockwork) {
                clockwork = tempItem.func_77946_l();
            }
            if (!(tempItem.func_77973_b() instanceof IClockwork)) continue;
            construct = tempItem.func_77946_l();
        }
        ItemStack output = construct;
        if (mainspring != null) {
            int currentTension = NBTHelper.getInt(mainspring, "tension_energy");
            int maxTension = NBTHelper.getInt(mainspring, "max_tension");
            NBTHelper.setInteger(output, "tension_energy", currentTension);
            NBTHelper.setInteger(output, "max_tension", maxTension);
            if (output != null) {
                if (maxTension / output.func_77958_k() == 0) {
                    output.func_77964_b(output.func_77958_k());
                } else {
                    output.func_77964_b(output.func_77958_k() - currentTension / (maxTension / output.func_77958_k()));
                }
            }
        }
        if (clockwork != null) {
            NBTHelper.setInteger(output, "cp_quality", NBTHelper.getInt(clockwork, "cp_quality"));
            NBTHelper.setInteger(output, "cp_speed", NBTHelper.getInt(clockwork, "cp_speed"));
            NBTHelper.setInteger(output, "cp_memory", NBTHelper.getInt(clockwork, "cp_memory"));
            NBTTagList nbtList = new NBTTagList();
            NBTTagCompound tag = new NBTTagCompound();
            clockwork.func_77955_b(tag);
            nbtList.func_74742_a((NBTBase)tag);
            NBTHelper.setTagList(output, "cp_clockwork", nbtList);
        }
        return output;
    }

    public ItemStack getMultitoolRecipe() {
        boolean fluxItem = false;
        boolean multitool = false;
        boolean doubles = false;
        for (int n = 0; n < this.matrix.func_70302_i_(); ++n) {
            ItemStack item = this.matrix.func_70301_a(n);
            if (item == null) continue;
            if (item.func_77973_b() instanceof ItemTemporalMultitool) {
                if (multitool) {
                    doubles = true;
                }
                multitool = true;
                ItemStack[] items = NBTHelper.getInventoryFromNBTTag(item, "temporal_items");
                if (items == null || items.length < 20) continue;
                return null;
            }
            if (!(item.func_77973_b().getItemStackLimit(item) != 1 || item.func_77973_b() instanceof ItemBlock || item.func_77973_b() instanceof ItemTemporalMultitool || item.func_77973_b() instanceof ItemPotion || item.func_77973_b() instanceof ItemArmor || item.func_77973_b() instanceof ItemBucket)) {
                if (fluxItem) {
                    doubles = true;
                }
                fluxItem = true;
                if (!NBTHelper.hasTag(item, "temporal_items")) continue;
                return null;
            }
            return null;
        }
        if (fluxItem && multitool && !doubles) {
            return this.multitoolResult();
        }
        return null;
    }

    private ItemStack multitoolResult() {
        ItemStack fluxableItem = null;
        ItemStack multitool = null;
        for (int n = 0; n < this.matrix.func_70302_i_(); ++n) {
            ItemStack tempItem = this.matrix.func_70301_a(n);
            if (tempItem == null) continue;
            if (tempItem.func_77973_b() instanceof ItemTemporalMultitool) {
                multitool = tempItem.func_77946_l();
            }
            if (tempItem.func_77973_b().getItemStackLimit(tempItem) != 1 || tempItem.func_77973_b() instanceof ItemBlock || tempItem.func_77973_b() instanceof ItemTemporalMultitool) continue;
            fluxableItem = tempItem.func_77946_l();
        }
        if (fluxableItem != null && multitool != null) {
            ItemStack[] resultInventory;
            ItemStack[] inventory = NBTHelper.getInventoryFromNBTTag(multitool, "temporal_items");
            if (inventory != null) {
                resultInventory = new ItemStack[inventory.length + 1];
                for (int n = 0; n < inventory.length; ++n) {
                    resultInventory[n] = inventory[n];
                }
            } else {
                resultInventory = new ItemStack[1];
            }
            resultInventory[resultInventory.length - 1] = fluxableItem;
            NBTHelper.setNBTTagListFromInventory(multitool, "temporal_items", resultInventory);
            return multitool;
        }
        return null;
    }

    public ItemStack getPocketWatchRecipe() {
        ItemStack pocketWatch = null;
        ItemStack module = null;
        boolean moduleExists = false;
        boolean pocketWatchExists = false;
        for (int n = 0; n < this.matrix.func_70302_i_(); ++n) {
            ItemStack item = this.matrix.func_70301_a(n);
            if (item == null) continue;
            if (item.func_77973_b() instanceof ItemPocketWatch) {
                pocketWatch = item.func_77946_l();
                if (pocketWatchExists) {
                    return null;
                }
                pocketWatchExists = true;
                ItemStack[] items = NBTHelper.getInventoryFromNBTTag(item, "pw_modules");
                if (items == null || items.length < 20) continue;
                return null;
            }
            if (item.func_77973_b() instanceof ItemModule) {
                module = item.func_77946_l();
                if (moduleExists) {
                    return null;
                }
                moduleExists = true;
                if (!NBTHelper.hasTag(item, "pw_modules")) continue;
                return null;
            }
            return null;
        }
        if (pocketWatch != null && module != null && NBTHelper.hasTag(pocketWatch, "pw_modules")) {
            ItemStack[] items = NBTHelper.getInventoryFromNBTTag(pocketWatch, "pw_modules");
            for (int n = 0; n < items.length; ++n) {
                if (items[n] == null || !items[n].func_77973_b().equals(module.func_77973_b())) continue;
                return null;
            }
        }
        if (moduleExists && pocketWatchExists) {
            return this.pocketWatchResult();
        }
        return null;
    }

    private ItemStack pocketWatchResult() {
        ItemStack module = null;
        ItemStack pocketWatch = null;
        for (int n = 0; n < this.matrix.func_70302_i_(); ++n) {
            ItemStack tempItem = this.matrix.func_70301_a(n);
            if (tempItem == null) continue;
            if (tempItem.func_77973_b() instanceof ItemPocketWatch) {
                pocketWatch = tempItem.func_77946_l();
            }
            if (!(tempItem.func_77973_b() instanceof ItemModule)) continue;
            module = tempItem.func_77946_l();
        }
        if (module != null && pocketWatch != null) {
            ItemStack[] resultInventory;
            ItemStack[] inventory = NBTHelper.getInventoryFromNBTTag(pocketWatch, "pw_modules");
            if (inventory != null) {
                resultInventory = new ItemStack[inventory.length + 1];
                for (int n = 0; n < inventory.length; ++n) {
                    resultInventory[n] = inventory[n];
                }
            } else {
                resultInventory = new ItemStack[1];
            }
            resultInventory[resultInventory.length - 1] = module;
            NBTHelper.setNBTTagListFromInventory(pocketWatch, "pw_modules", resultInventory);
            return pocketWatch;
        }
        return null;
    }

    public void func_75134_a(EntityPlayer p_75134_1_) {
        super.func_75134_a(p_75134_1_);
        if (!this.world.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = this.matrix.func_70304_b(i);
                if (itemstack == null) continue;
                p_75134_1_.func_71019_a(itemstack, false);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer p_75145_1_) {
        return this.matrix.func_70300_a(p_75145_1_);
    }

    public ItemStack func_82846_b(EntityPlayer p_82846_1_, int p_82846_2_) {
        return null;
    }
}

