/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.block.extractor;

import java.util.HashMap;
import lumaceon.mods.clockworkphase.block.tileentity.TileEntityExtractor;
import lumaceon.mods.clockworkphase.lib.Phases;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ExtractorAreas {
    public static final HashMap[] EXTRACTORS = new HashMap[]{new HashMap(10), new HashMap(10), new HashMap(10), new HashMap(10), new HashMap(10), new HashMap(10), new HashMap(10), new HashMap(10)};
    public HashMap<Integer, ExtractorArea> areas = new HashMap(100);

    public ExtractorArea getValidArea(World world, int x, int y, int z) {
        ExtractorArea area = null;
        boolean found = false;
        for (int n = 0; n < this.areas.values().toArray().length && !found; ++n) {
            area = (ExtractorArea)this.areas.values().toArray()[n];
            if (x < area.lowX || x > area.highX || y < area.lowY || y > area.highY || z < area.lowZ || z > area.highZ) continue;
            found = true;
        }
        if (found) {
            TileEntity te = world.func_147438_o(area.extractorX, area.extractorY, area.extractorZ);
            if (te != null && te instanceof TileEntityExtractor) {
                return area;
            }
            this.removeArea(area.id);
            return this.getValidArea(world, x, y, z);
        }
        return null;
    }

    public static boolean doesAreaExist(World world, int x, int y, int z) {
        for (int n = 0; n < EXTRACTORS.length; ++n) {
            ExtractorAreas areas = (ExtractorAreas)EXTRACTORS[n].get(world.field_73011_w.field_76574_g);
            if (areas == null) continue;
            for (int g = 0; g < areas.areas.size(); ++g) {
                ExtractorArea area = areas.areas.get(g);
                if (area == null || area.extractorX != x || area.extractorY != y || area.extractorZ != z) continue;
                return true;
            }
        }
        return false;
    }

    public int addArea(int extractorX, int extractorY, int extractorZ, int lowX, int lowY, int lowZ, int highX, int highY, int highZ) {
        int id = this.getNextFreeId();
        this.areas.put(id, new ExtractorArea(extractorX, extractorY, extractorZ, lowX, lowY, lowZ, highX, highY, highZ, id));
        return id;
    }

    public Integer getNextFreeId() {
        int n = -1;
        boolean found = false;
        while (n < 100000 && !found) {
            found = !this.areas.containsKey(++n);
        }
        return n;
    }

    public void removeArea(Integer id) {
        this.areas.remove(id);
    }

    public static ExtractorAreas getAreasFromWorld(World world, Phases phase) {
        return ExtractorAreas.getAreasFromWorldId(world.field_73011_w.field_76574_g, phase);
    }

    public static ExtractorAreas getAreasFromWorldId(int id, Phases phase) {
        HashMap extractorWorlds = EXTRACTORS[phase.ordinal()];
        ExtractorAreas extractorAreas = (ExtractorAreas)extractorWorlds.get(id);
        if (extractorAreas == null) {
            extractorAreas = new ExtractorAreas();
            extractorWorlds.put(id, extractorAreas);
        }
        return extractorAreas;
    }

    public class ExtractorArea {
        public int extractorX;
        public int extractorY;
        public int extractorZ;
        public int highX;
        public int highY;
        public int highZ;
        public int lowX;
        public int lowY;
        public int lowZ;
        public int id;

        public ExtractorArea(int extractorX, int extractorY, int extractorZ, int lowX, int lowY, int lowZ, int highX, int highY, int highZ, int id) {
            this.extractorX = extractorX;
            this.extractorY = extractorY;
            this.extractorZ = extractorZ;
            this.highX = highX;
            this.highY = highY;
            this.highZ = highZ;
            this.lowX = lowX;
            this.lowY = lowY;
            this.lowZ = lowZ;
            this.id = id;
        }
    }
}

