/*
 * Decompiled with CFR 0.152.
 */
package latmod.silicio.tile;

import cofh.api.energy.EnergyStorage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import latmod.core.InvUtils;
import latmod.core.LatCoreMC;
import latmod.core.tile.IGuiTile;
import latmod.core.tile.IWailaTile;
import latmod.core.tile.TileInvLM;
import latmod.silicio.gui.GuiModuleCopier;
import latmod.silicio.gui.container.ContainerModuleCopier;
import latmod.silicio.item.modules.ICBModule;
import latmod.silicio.tile.ICBEnergyTile;
import latmod.silicio.tile.ICBNetTile;
import latmod.silicio.tile.TileCBController;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileModuleCopier
extends TileInvLM
implements IGuiTile,
ICBNetTile,
ICBEnergyTile,
IWailaTile.Body,
ISidedInventory {
    public static final int maxProg = 50;
    public static final int energyRequired = 1200;
    public EnergyStorage energyStorage = new EnergyStorage(4800);
    public ItemStack item = null;
    public int progress = 0;

    public TileModuleCopier() {
        super(3);
    }

    public void readTileData(NBTTagCompound tag) {
        super.readTileData(tag);
        this.energyStorage.readFromNBT(tag);
        this.item = InvUtils.loadStack((NBTTagCompound)tag, (String)"Item");
        this.progress = tag.func_74765_d("Prog");
    }

    public void writeTileData(NBTTagCompound tag) {
        super.writeTileData(tag);
        this.energyStorage.writeToNBT(tag);
        InvUtils.saveStack((NBTTagCompound)tag, (String)"Item", (ItemStack)this.item);
        tag.func_74777_a("Prog", (short)this.progress);
    }

    public boolean onRightClick(EntityPlayer ep, ItemStack is, int side, float x, float y, float z) {
        if (this.isServer()) {
            LatCoreMC.openGui((EntityPlayer)ep, (IGuiTile)this, null);
        }
        return true;
    }

    public Container getContainer(EntityPlayer ep, NBTTagCompound data) {
        return new ContainerModuleCopier(ep, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer ep, NBTTagCompound data) {
        return new GuiModuleCopier(new ContainerModuleCopier(ep, this));
    }

    @Override
    public void preUpdate(TileCBController c) {
        boolean server = this.isServer();
        if (this.progress == 0 && this.items[0] != null && this.items[1] != null && this.energyStorage.getEnergyStored() >= 1200 && this.items[0].func_77973_b() instanceof ICBModule && this.items[1].func_77942_o() && InvUtils.itemsEquals((ItemStack)this.items[0], (ItemStack)this.items[1], (boolean)false, (boolean)false)) {
            this.item = InvUtils.singleCopy((ItemStack)this.items[0]);
            this.item.func_77982_d(this.items[1].func_77978_p());
            this.items[0] = InvUtils.reduceItem((ItemStack)this.items[0]);
            this.progress = 1;
            this.energyStorage.extractEnergy(1200, false);
            this.func_70296_d();
        }
        if (this.progress >= 50) {
            if (server && this.item != null && InvUtils.addSingleItemToInv((ItemStack)this.item, (IInventory)this, (int[])new int[]{2}, (int)-1, (boolean)true)) {
                this.item = null;
                this.progress = 0;
                this.func_70296_d();
            }
        } else if (this.progress >= 1) {
            ++this.progress;
        }
    }

    @Override
    public void onUpdateCB() {
    }

    @Override
    public void onControllerDisconnected() {
    }

    @Override
    public boolean isSideEnabled(int side) {
        return true;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void addWailaBody(IWailaDataAccessor data, IWailaConfigHandler config, List<String> info) {
        ICBEnergyTile.Helper.addWaila(this.energyStorage, info);
    }

    public float getProgressF() {
        return this.progress > 0 ? (float)(this.progress + 1) / 50.0f : 0.0f;
    }

    public int[] func_94128_d(int s) {
        int[] nArray;
        if (s == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public boolean func_102007_a(int i, ItemStack is, int s) {
        return is != null && is.func_77973_b() instanceof ICBModule;
    }

    public boolean func_102008_b(int i, ItemStack is, int s) {
        return s == 0;
    }
}

